<?php
    $table_name = 'time_slots';
?>
<?php $__env->startSection('table'); ?>
    <?php echo e($table_name); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('mainContent'); ?>
    <input type="hidden" id="row_count" value="1">
    <?php echo generateBreadcrumb(); ?>


    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-md-3">
                    <div class="white-box mb_30">
                        <div class="box_header common_table_header mb-0">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-20 mr-30 mb_xs_15px mb_sm_20px">
                                    <?php if(!isset($editTimeSlot)): ?>
                                        <?php echo e(__('appointment.Add New Slot')); ?>

                                    <?php else: ?>
                                        <?php echo e(__('appointment.Update Slot')); ?>

                                    <?php endif; ?>
                                </h3>
                            </div>
                        </div>

                        <?php if(isset($editTimeSlot)): ?>
                            <?php if(permissionCheck('appointment.time-slot.edit')): ?>
                                <form action="<?php echo e(route('appointment.time-slot.update', $editTimeSlot->id)); ?>"
                                      method="POST" class="form-horizontal" id="timeSlot-form" name="timeSlot-form">
                                    <?php echo method_field('PUT'); ?>
                                    <?php echo csrf_field(); ?>

                                    <?php endif; ?>
                                    <?php else: ?>
                                        <?php if(permissionCheck('appointment.time-slot.store')): ?>
                                            <form action="<?php echo e(route('appointment.time-slot.store')); ?>" method="POST"
                                                  class="form-horizontal" enctype="multipart/form-data"
                                                  name="timeSlot-form">
                                                <?php echo csrf_field(); ?>

                                                <?php endif; ?>
                                                <?php endif; ?>
                                                <div class="row">


                                                    <div class="col-xl-12 input-right-icon">
                                                        <label
                                                            class="primary_input_label mt-1"><?php echo e(__('appointment.Start Time')); ?>

                                                            <span
                                                                class="required_mark">*</span></label>
                                                        <div class="primary_input">
                                                            <input required
                                                                   class="primary-input primary_input_field  time form-control<?php echo e(@$errors->has('start_time') ? ' is-invalid' : ''); ?>"
                                                                   type="text" name="start_time"
                                                                   value="<?php echo e(isset($editTimeSlot) ? old('start_time', $editTimeSlot->start_time) : old('start_time')); ?>">
                                                        </div>

                                                        <?php if($errors->has('start_time')): ?>
                                                            <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e(@$errors->first('start_time')); ?></strong>
                                        </span>
                                                        <?php endif; ?>
                                                    </div>


                                                    <div class="col-xl-12 mt-10 input-right-icon">
                                                        <label
                                                            class="primary_input_label mt-1"><?php echo e(__('appointment.End Time')); ?> </label>
                                                        <div class="primary_input">
                                                            <input
                                                                class="primary-input primary_input_field  time form-control<?php echo e(@$errors->has('time') ? ' is-invalid' : ''); ?>"
                                                                type="text" name="end_time"
                                                                value="<?php echo e(isset($editTimeSlot) ? old('end_time', $editTimeSlot->end_time) : old('end_time')); ?>">

                                                        </div>

                                                        <?php if($errors->has('end_time')): ?>
                                                            <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e(@$errors->first('end_time')); ?></strong>
                                        </span>
                                                        <?php endif; ?>
                                                    </div>


                                                    <?php if(auth()->user()->role_id == 1): ?>
                                                        <div class="col-xl-12 mt-10">
                                                            <div class="primary_input mb-25">
                                                                <label class="primary_input_label"
                                                                       for="user_id"><?php echo e(__('common.Instructor')); ?></label>
                                                                <select class="primary_select " name="user" id="user_id"
                                                                    <?php echo e($errors->has('user') ? 'autofocus' : ''); ?>>
                                                                    <option
                                                                        data-display="<?php echo e(__('appointment.Select Instructor')); ?> "
                                                                        value="">
                                                                        <?php echo e(__('appointment.Select Instructor')); ?> </option>
                                                                    <?php $__currentLoopData = $instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option
                                                                            value="<?php echo e($instructor->id); ?>" <?php echo e(isset($editTimeSlot) ? ($editTimeSlot->user_id == $instructor->id ? 'selected' : '') : ''); ?>><?php echo e($instructor->name); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php
                                                        $tooltip = '';
                                                        if (permissionCheck('appointment.time-slot.store')) {
                                                            $tooltip = '';
                                                        } else {
                                                            $tooltip = trans('courses.You have no permission to add');
                                                        }
                                                    ?>
                                                    <div class="col-lg-12 text-center">
                                                        <div class="d-flex justify-content-center pt_20">
                                                            <button type="submit"
                                                                    class="primary-btn semi_large fix-gr-bg"
                                                                    data-bs-toggle="tooltip"
                                                                    title="<?php echo e(@$tooltip); ?>" id="save_button_parent">
                                                                <i class="ti-check"></i>
                                                                <?php if(!isset($editTimeSlot)): ?>
                                                                    <?php echo e(__('common.Save')); ?>

                                                                <?php else: ?>
                                                                    <?php echo e(__('common.Update')); ?>

                                                                <?php endif; ?>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="white-box">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-20" id="page_title"><?php echo e(__('appointment.Time Slot List')); ?></h3>
                            </div>
                        </div>
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col"><?php echo e(__('common.SL')); ?></th>
                                            <th scope="col"><?php echo e(__('appointment.Start Time')); ?></th>
                                            <th scope="col"><?php echo e(__('appointment.End Time')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Duration')); ?></th>

                                            <th scope="col"><?php echo e(__('common.Instructor')); ?></th>

                                            <th scope="col"><?php echo e(__('common.Status')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Action')); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $timeSlots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $slot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th class="m-2"><?php echo e($loop->iteration); ?></th>
                                                <td><?php echo e(date('h:i A', strtotime(@$slot->start_time))); ?></td>
                                                <td><?php echo e(date('h:i A', strtotime(@$slot->end_time))); ?></td>
                                                <td><?php echo e($slot->duration); ?></td>
                                                <td><?php echo e($slot->instructor->name); ?></td>


                                                <td class="nowrap">
                                                    <label class="switch_toggle">
                                                        <input type="checkbox"
                                                               <?php if(auth()->user()->role_id !=1): ?>
                                                                   <?php if(auth()->user()->id == $slot->created_by): ?>class="status_enable_disable"
                                                               <?php else: ?>
                                                                   disabled
                                                               <?php endif; ?>
                                                               <?php else: ?>
                                                                   class="status_enable_disable"
                                                               <?php endif; ?>
                                                               <?php if(@$slot->status == 1): ?> checked <?php endif; ?>
                                                               value="<?php echo e(@$slot->id); ?>">
                                                        <i class="slider round"></i>
                                                    </label>
                                                </td>

                                                <td>
                                                    <!-- shortby  -->
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu1<?php echo e(@$slot->id); ?>"
                                                                data-bs-toggle="dropdown"
                                                                aria-haspopup="true" aria-expanded="false">
                                                            <?php echo e(__('common.Select')); ?>

                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu1<?php echo e(@$slot->id); ?>">

                                                            <?php if(permissionCheck('appointment.time-slot.edit')): ?>
                                                                <a class="dropdown-item edit_brand"
                                                                   href="<?php echo e(route('appointment.time-slot.edit', @$slot->id)); ?>"><?php echo e(__('common.Edit')); ?></a>
                                                            <?php endif; ?>
                                                            <?php if(permissionCheck('appointment.time-slot.destroy')): ?>
                                                                <a onclick="confirm_modal('<?php echo e(route('appointment.time-slot.destroy', @$slot->id)); ?>');"
                                                                   class="dropdown-item edit_brand"><?php echo e(__('common.Delete')); ?></a>
                                                            <?php endif; ?>

                                                        </div>
                                                    </div>
                                                    <!-- shortby  -->
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php echo $__env->make('backend.partials.delete_modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>

    <script type="application/javascript">
        (function ($) {
            "use strict";

            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4]);

            $('#lms_table').DataTable(dataTableOptions);
        })(jQuery);


    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('appointment::layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/Appointment/Resources/views/timeSlot/time_slot.blade.php ENDPATH**/ ?>