<?php $__env->startSection('mainContent'); ?>
    <?php echo generateBreadcrumb(); ?>

    <style>
        .target_list {
            list-style: none;
            padding: 0;
            max-height: 200px;
            overflow-y: auto;

        }
    </style>
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="main-title d-md-flex justify-content-md-between mb-20">
                            <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title"><?php echo e($data['title']); ?></h3>
                            <ul class="d-flex">
                                <li>
                                    <a class="primary-btn radius_30px fix-gr-bg"
                                       href="<?php echo e(route('cashback.rules.create')); ?>"><i
                                            class="ti-plus"></i><?php echo e(_trans('cashback.Add Rule')); ?> </a>
                                </li>
                            </ul>

                        </div>

                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <?php $__currentLoopData = $data['table_columns']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $th): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <th scope="col"><?php echo e($th); ?></th>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $data['rules']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th><?php echo e($key + 1); ?></th>

                                                <td><?php echo e(@$rule->getTranslation('title', auth()->user()->language_code ?? 'en')); ?></td>
                                                <td><?php echo e(_trans('cashback.'.@$rule->rule_specific_item->target_type)); ?></td>
                                                <td>
                                                    <?php echo e($rule->amount_type == 'percent' ? $rule->amount . '%' : getPriceFormat($rule->amount)); ?>

                                                </td>
                                                <td>
                                                    <?php echo e(showPrice($rule->userCashbackDetails->sum('cashback_amount'))); ?>

                                                </td>
                                                <td>
                                                    <?php echo e($rule->totalUser()); ?>

                                                </td>
                                                <td><?php echo e(showDate($rule->start_datetime) . ' | ' . showTime($rule->start_datetime)); ?>

                                                </td>
                                                <td><?php echo e($rule->end_datetime != null ? showDate($rule->end_datetime) . ' | ' . showTime($rule->end_datetime) : _trans('cashback.Unlimited')); ?>

                                                </td>
                                                <td>
                                                    <?php echo e($rule->statusText); ?>

                                                </td>
                                                <td>
                                                    <!-- shortby  -->
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu2" data-bs-toggle="dropdown"
                                                                aria-haspopup="true"
                                                                aria-expanded="false">
                                                            <?php echo e(__('common.Select')); ?>

                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu2">
                                                            <?php if(permissionCheck('cashback.rules.edit')): ?>
                                                                <a class="dropdown-item edit_brand"
                                                                   href="<?php echo e(route('cashback.rules.edit', @$rule->id)); ?>"><?php echo e(_trans('common.Edit')); ?></a>
                                                            <?php endif; ?>

                                                            <a class="dropdown-item" data-bs-toggle="modal"
                                                               data-bs-target="#viewCashbackRuleModal<?php echo e(@$rule->id); ?>"
                                                               href="#"><?php echo e(__('common.View')); ?></a>


                                                            <?php if(permissionCheck('cashback.rules.delete')): ?>
                                                                <a class="dropdown-item" data-bs-toggle="modal"
                                                                   data-bs-target="#deleteQuestionGroupModal<?php echo e(@$rule->id); ?>"
                                                                   href="#"><?php echo e(__('common.Delete')); ?></a>
                                                            <?php endif; ?>

                                                        </div>
                                                    </div>
                                                    <!-- shortby  -->
                                                </td>
                                            </tr>

                                            <div class="modal fade admin-query"
                                                 id="viewCashbackRuleModal<?php echo e($rule->id); ?>">
                                                <div class="modal-dialog modal-dialog-centered modal_1000px">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"><?php echo e(_trans('cashback.Cashback')); ?> <?php echo e(_trans('cashback.Rule')); ?> <?php echo e(__('common.View')); ?></h4>
                                                            <button type="button" class="btn-close"
                                                                    data-bs-dismiss="modal"><i
                                                                    class="ti-close "></i></button>
                                                        </div>

                                                        <div class="modal-body">
                                                            <div class="text-center">
                                                                <h4> <?php echo e(@$rule->getTranslation('title', auth()->user()->language_code ?? 'en')); ?></h4>
                                                            </div>
                                                            <hr>
                                                            <div class="row">
                                                                <div class="col-lg-6"
                                                                     style="border-right: 1px solid gray">
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            <?php echo e(_trans('cashback.Target Type')); ?>

                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            <?php echo e(_trans('cashback.'.@$rule->rule_specific_item->target_type)); ?>

                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            <?php echo e(_trans('cashback.Amount')); ?>

                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            <?php echo e($rule->amount_type == 'percent' ? $rule->amount . '%' : getPriceFormat($rule->amount)); ?>

                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            <?php echo e(_trans('cashback.Paid Amount')); ?>

                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            <?php echo e(showPrice($rule->userCashbackDetails->sum('cashback_amount'))); ?>

                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            <?php echo e(_trans('cashback.Users')); ?>

                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            <?php echo e($rule->totalUser()); ?>

                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            <?php echo e(_trans('cashback.Start Date')); ?>

                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            <?php echo e(showDate($rule->start_datetime) . ' | ' . showTime($rule->start_datetime)); ?>

                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            <?php echo e(_trans('cashback.End Date')); ?>

                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            <?php echo e($rule->end_datetime != null ? showDate($rule->end_datetime) . ' | ' . showTime($rule->end_datetime) : _trans('cashback.Unlimited')); ?>

                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            <?php echo e(_trans('cashback.Status')); ?>

                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            <?php echo e($rule->statusText); ?>

                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-lg-4 fw-bold">
                                                                            <?php echo e(_trans('cashback.Apply Cashback Per Item')); ?>

                                                                        </div>
                                                                        <div class="col-lg-1">
                                                                            :
                                                                        </div>
                                                                        <div class="col-lg-7">
                                                                            <?php echo e($rule->apply_cashback_per_item == 1? _trans('cashback.Yes') : _trans('cashback.No')); ?>

                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <div class="col-lg-6"
                                                                     style="border-left: 1px solid gray">
                                                                    <h3 class="text-center">
                                                                        <?php echo e(_trans('cashback.Target')); ?>

                                                                        (<?php echo e(_trans('cashback.'.@$rule->rule_specific_item->target_type)); ?> <?php echo e($rule->rule_specific_item->target != null ? '->'._trans('cashback.'.Str::ucfirst(Str::replace('_',' ',@$rule->rule_specific_item->target))) :''); ?>

                                                                        )
                                                                    </h3>
                                                                    <div class="">
                                                                        <?php
                                                                            $rule_items= $rule->rule_specific_item ? $rule->rule_specific_item->rule_specific_item_details_relation : [];
                                                                        ?>
                                                                        <ul class="target_list">
                                                                            <?php $__currentLoopData = $rule_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <li>
                                                                                    <?php
                                                                                        $json_check = json_decode($item->itemInfo->name, true);
                                                                                    ?>

                                                                                    <?php if($json_check): ?>
                                                                                        <?php echo e(++$key); ?>

                                                                                        . <?php echo e(json_trans(@$item->itemInfo->name, auth()->user()->language_code ?? 'en')); ?>

                                                                                    <?php else: ?>
                                                                                        <?php echo e(++$key); ?>

                                                                                        . <?php echo e(@$item->itemInfo->name); ?>

                                                                                    <?php endif; ?>
                                                                                </li>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="mt-40 d-flex justify-content-end">
                                                                <button type="button" class="primary-btn tr-bg"
                                                                        data-bs-dismiss="modal"><?php echo e(__('common.Cancel')); ?></button>

                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal fade admin-query"
                                                 id="deleteQuestionGroupModal<?php echo e($rule->id); ?>">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"><?php echo e(__('common.Delete')); ?>

                                                                <?php echo e(_trans('cashback.Cashback')); ?>

                                                                <?php echo e(_trans('cashback.Rule')); ?></h4>
                                                            <button type="button" class="btn-close"
                                                                    data-bs-dismiss="modal"><i
                                                                    class="ti-close "></i></button>
                                                        </div>

                                                        <div class="modal-body">
                                                            <div class="text-center">
                                                                <h4> <?php echo e(__('common.Are you sure to delete ?')); ?></h4>
                                                            </div>

                                                            <div class="mt-40 d-flex justify-content-between">
                                                                <button type="button" class="primary-btn tr-bg"
                                                                        data-bs-dismiss="modal"><?php echo e(__('common.Cancel')); ?></button>
                                                                <form action="<?php echo e(route('cashback.rules.delete')); ?>" method="POST" enctype="multipart/form-data">
                                                                <input type="hidden" name="id"
                                                                       value="<?php echo e($rule->id); ?>">
                                                                <button class="primary-btn fix-gr-bg"
                                                                        type="submit"><?php echo e(__('common.Delete')); ?></button>
                                                                </form>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <input type="hidden" name="status_route" class="status_route" value="<?php echo e(route('coupons.status_update')); ?>">

<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('public/backend/js/category.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/Cashback/Resources/views/rule/index.blade.php ENDPATH**/ ?>