<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/backend/css/student_list.css')); ?><?php echo e(assetVersion()); ?>"/>
<?php $__env->stopPush(); ?>
<?php
    $table_name='users';
?>
<?php $__env->startSection('table'); ?>
    <?php echo e($table_name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('mainContent'); ?>

    <?php echo generateBreadcrumb(); ?>


    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white_box mb_30">
                <div class="row justify-content-center">

                    <div class="col-lg-12">
                        <div class="white_box mb_30">
                            <div class="white_box_tittle list_header main-title mb-0">
                                <h3 class="mb-0"><?php echo e(__('courses.Advanced Filter')); ?> </h3>
                            </div>
                            <form action="<?php echo e(route('gamification.history')); ?>" method="GET">
                                <div class="row">

                                    <div class="col-lg-4 mt-20">
                                        <label class="primary_input_label"
                                               for="category"> <?php echo e(__('courses.Course')); ?> <?php echo e(__('common.Levels')); ?></label>
                                        <select class="primary_select" name="level" id="level">
                                            <option data-display="<?php echo e(__('common.All')); ?> <?php echo e(__('common.Levels')); ?>"
                                                    value=""><?php echo e(__('common.All')); ?> <?php echo e(__('common.Levels')); ?></option>
                                            <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($level->id); ?>" <?php echo e(request('level')==$level->id?'selected':''); ?>><?php echo e($level->title); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-lg-4 mt-20 courseDiv">
                                        <label class="primary_input_label"
                                               for="category"><?php echo e(__("courses.Courses")); ?></label>
                                        <select class="primary_select" name="course" id="course">
                                            <option data-display="<?php echo e(__('common.All')); ?> <?php echo e(__("courses.Courses")); ?>"
                                                    value=""><?php echo e(__('common.All')); ?> <?php echo e(__("courses.Courses")); ?></option>
                                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($course->id); ?>" <?php echo e(request('course')==$course->id?'selected':''); ?>><?php echo e($course->title); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-lg-4 mt-20">

                                        <label class="primary_input_label"
                                               for="category"><?php echo e(__('common.Institutes')); ?></label>
                                        <select class="primary_select" name="institute" id="institute">
                                            <option data-display="<?php echo e(__('common.All')); ?> <?php echo e(__('common.Institutes')); ?>"
                                                    value=""><?php echo e(__('common.All')); ?> <?php echo e(__('common.Institutes')); ?></option>
                                            <?php $__currentLoopData = $institutes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $institute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($institute->id); ?>" <?php echo e(request('institute')==$institute->id?'selected':''); ?>><?php echo e($institute->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-12 mt-20">
                                        <div class="search_course_btn text-end">
                                            <button type="submit"
                                                    class="primary-btn radius_30px   fix-gr-bg">
                                                <span class="ti-search pe-2"></span>

                                                <?php echo e(__('courses.Filter')); ?> </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="white_box mb_30">
                <div class="col-lg-12">
                    <div class="QA_section QA_section_heading_custom check_box_table">
                        <div class="QA_table ">
                            <!-- table-responsive -->
                            <div class="">
                                <table id="lms_table" class="table Crm_table_active3">
                                    <thead>
                                    <tr>
                                        <th scope="col"><?php echo e(__('common.SL')); ?></th>
                                        <th scope="col"><?php echo e(__('common.Image')); ?></th>
                                        <th scope="col"><?php echo e(__('common.Name')); ?></th>
                                        <th scope="col"><?php echo e(__('common.Email')); ?></th>
                                        <th scope="col"><?php echo e(__('common.Total')); ?> <?php echo e(__('common.Point')); ?></th>
                                        <th scope="col"><?php echo e(__('common.Spent')); ?> <?php echo e(__('common.Point')); ?></th>
                                        <th scope="col"><?php echo e(__('common.Remained')); ?> <?php echo e(__('common.Point')); ?></th>
                                        <th scope="col"><?php echo e(__('common.Action')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
            <div class="row justify-content-center">
            </div>

        </div>
    </section>


    <div class="modal fade admin-query" id="view_details">
        <div class="modal-dialog modal_1000px modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="ViewTitle"></h4>
                    <button type="button" class="close " data-bs-dismiss="modal">
                        <i class="ti-close "></i>
                    </button>
                </div>

                <div class="modal-body" id="viewBody" style="max-height: 500px;overflow-y: auto">

                </div>
            </div>
        </div>
    </div>
<h1 id="page_title" class="d-none"><?php echo e(__('setting.Gamification')); ?></h1>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>

    <?php

        $url = route('gamification.historyData').'?'.http_build_query(request()->all());
    ?>

    <script>

        dataTableOptions.serverSide = true
        dataTableOptions.processing = true
        dataTableOptions.ajax = '<?php echo $url; ?>';
        dataTableOptions.columns = [
            {data: 'DT_RowIndex', name: 'id', orderable: true},
            {data: 'image', name: 'image', orderable: false},
            {data: 'name', name: 'name'},
            {data: 'email', name: 'email'},
            {data: 'gamification_total_points', name: 'gamification_total_points'},
            {data: 'gamification_total_spent_points', name: 'gamification_total_spent_points'},
            {data: 'gamification_total_remain_points', name: 'gamification_total_remain_points', orderable: false},
            {data: 'action', name: 'action', orderable: false},
        ];
        dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 2, 3, 4, 5, 6]);

        let table = $('#lms_table').DataTable(dataTableOptions);


        $(document).on('click', '.detailsHistory', function () {
            let id = $(this).data('id');
            let type = $(this).data('type');
            let title = $(this).data('title');
            let url = '<?php echo e(url('/')); ?>/gamification/history-details/' + type + '/' + id;


            $.ajax({
                type: 'GET',
                url: url,
                dataType: "html",
                success: function (data) {
                    $("#ViewTitle").text(title);
                    $("#viewBody").html(data);
                    $("#view_details").modal('show');
                },
                error: function (data) {
                    toastr.error('Something Went Wrong', 'Error');
                }
            });


        });

        $("#level").on("change", function () {
            var url = $("#url").val();
            var formData = { id: $(this).val() };
            var lang = window._locale;
            console.log(lang)
            // AJAX request to fetch subcategory data
            $.ajax({
                type: "GET",
                data: formData,
                dataType: "json",
                url: url + "/admin/course/ajaxGetCourseByLevel",
                success: function (data) {
                    var $courseSelect = $("#course");
                    var $courseDiv = $("#courseDiv ul");

                    // Clear previous options except the first one
                    $courseSelect.find("option:not(:first)").remove();
                    $courseDiv.find("li:not(:first)").remove();

                    if (data.length) {
                        // Loop through the subcategories and append them
                        $.each(data, function (i, item) {
                            $.each(item, function (i, section) {
                                var option = $("<option>", {
                                    value: section.id,
                                    text: section.title[lang],
                                });
                                $courseSelect.append(option);

                                var listItem = "<li data-value='" + section.id + "' class='option'>" + section.title[lang] + "</li>";
                                $courseDiv.append(listItem);
                            });
                        });
                    } else {
                        // Reset subcategory if no data is available
                        $("#courseDiv .current").html("All Course");
                    }

                    // Refresh NiceSelect plugin
                    $courseSelect.niceSelect('update');
                },
                error: function (data) {
                    console.log("Error:", data);
                },
            });
        });

    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/Setting/Resources/views/gamification/history.blade.php ENDPATH**/ ?>