<?php
    $table_name='surveys';
?>
<?php $__env->startSection('table'); ?>
    <?php echo e($table_name); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('mainContent'); ?>
    <?php echo generateBreadcrumb(); ?>



    <div class="row">
        <div class="col-lg-12">
            <div class="white-box mb-30">
                <form method="GET" action="" class="form-horizontal" id="search_group">
                    <div class="row">

                        <div class="col-lg-4 mt-30-md md_mb_20">
                            <label class="primary_input_label"
                                   for="">  <?php echo e(__('survey.Survey Type')); ?></label>
                            <select
                                <?php echo e($errors->has('survey_type') ? ' autofocus' : ''); ?>

                                class="primary_select<?php echo e($errors->has('survey_type') ? ' is-invalid' : ''); ?>"
                                name="survey_type" id="survey_type">
                                <option
                                    value="1" <?php echo e(request('survey_type')=='1'?'selected':''); ?>> <?php echo e(__('survey.Course survey')); ?></option>
                                <option
                                    value="2" <?php echo e(request('survey_type')=='2'?'selected':''); ?>> <?php echo e(__('survey.Independence')); ?></option>
                            </select>

                        </div>

                        <div class="col-lg-4 mt-30-md md_mb_20">
                            <label class="primary_input_label" for="category_id"><?php echo e(__('common.Category')); ?></label>
                            <select class="primary_select "
                                    id="category" name="category">
                                <option data-display=" <?php echo e(__('common.Select')); ?>" value=""> <?php echo e(__('common.Category')); ?>

                                </option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($category->parent_id==0): ?>
                                        <?php echo $__env->make('backend.categories._single_select_option',['category'=>$category,'level'=>1], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                        </div>


                        <div class="col-lg-12 mt-3  ">
                            <label class="primary_input_label" for=""></label>
                            <button type="submit" class="primary-btn  fix-gr-bg">
                                <span class="ti-search pe-2"></span>
                                <?php echo e(__('quiz.Search')); ?>

                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row justify-content-center">

                    <div class="col-lg-12">

                        <div class="main-title d-flex justify-content-between">
                            <div>
                                <h3 class="mb-20" id="page_title"><?php echo e(__('survey.Survey')); ?> <?php echo e(__('common.List')); ?></h3>

                            </div>
                            <div class="ps-3">
                                <?php if(permissionCheck('survey.survey_store')): ?>
                                    <a class="primary-btn radius_30px fix-gr-bg"
                                       href="<?php echo e(route('survey.survey_add')); ?>">
                                        <i class="ti-plus"></i><?php echo e(__('common.Add')); ?>

                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col"><?php echo e(__('common.SL')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Name')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Type')); ?></th>
                                            <th scope="col"><?php echo e(__('courses.Course')); ?></th>
                                            <?php if(isModuleActive('Org')): ?>
                                                <th scope="col"><?php echo e(__('survey.Created By')); ?></th>
                                                <th scope="col"><?php echo e(__('org.Org Chart')); ?></th>
                                                <th scope="col"><?php echo e(__('org.Job Position')); ?></th>
                                            <?php endif; ?>
                                            <th scope="col"><?php echo e(__('survey.Participants')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Published')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Status')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Action')); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $surveys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $survey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td scope="col"><?php echo e(translatedNumber($index+1)); ?></td>
                                                <td scope="col"><?php echo e($survey->title); ?></td>
                                                <td scope="col"><?php echo e($survey->survey_type==1?trans('survey.Course Survey'):trans('survey.Independence')); ?></td>
                                                <td scope="col"><?php echo e($survey->course->title); ?></td>
                                                <?php if(isModuleActive('Org')): ?>
                                                    <td scope="col"><?php echo e($survey->user->name); ?></td>
                                                    <td scope="col">
                                                        <?php if($survey->audience==1): ?>
                                                            <?php echo e(trans('blog.Public')); ?>

                                                        <?php else: ?>

                                                            <a type="button"
                                                               class="primary-btn radius_30px fix-gr-bg text-white  btn-modal"
                                                               data-container="#commonModal"
                                                               href="<?php echo e(routeIsExist('org.branch.survey')?route('org.branch.survey',$survey->id):''); ?>">
                                                                <?php echo e(trans('blog.Specify')); ?>

                                                            </a>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td scope="col">
                                                        <?php if($survey->position_audience==1): ?>
                                                            <?php echo e(trans('common.All')); ?>

                                                        <?php else: ?>
                                                            <a type="button"
                                                               class="primary-btn radius_30px fix-gr-bg text-white  btn-modal"
                                                               data-container="#commonModal"
                                                               href="<?php echo e(routeIsExist('org.position.survey')?route('org.position.survey',$survey->id):''); ?>">
                                                                <?php echo e(trans('blog.Specify')); ?>

                                                            </a>
                                                        <?php endif; ?>
                                                    </td>
                                                <?php endif; ?>
                                                <td scope="col"><?php echo e(translatedNumber($survey->participants->count())); ?></td>
                                                <td> <?php echo e($survey->isPublish); ?></td>
                                                <td class="nowrap">
                                                    <?php if(permissionCheck('survey.change_status')): ?>
                                                        <label class="switch_toggle ml-20" for="status<?php echo e($survey->id); ?>">
                                                            <input type="checkbox" class="status_enable_disable"
                                                                   name="status" id="status<?php echo e($survey->id); ?>"
                                                                   <?php echo e($survey->status==1? 'checked':''); ?>  value="<?php echo e($survey->id); ?>">
                                                            <i class="slider round"></i>
                                                        </label>
                                                    <?php else: ?>
                                                        <?php if($survey->status==1): ?>
                                                            Enabled
                                                        <?php else: ?>
                                                            Disabled

                                                        <?php endif; ?>
                                                    <?php endif; ?>

                                                </td>

                                                <td scope="col">
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu2" data-bs-toggle="dropdown"
                                                                aria-haspopup="true" aria-expanded="false">
                                                            <?php echo e(__('common.Action')); ?>

                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu2" style="">
                                                            <?php if(permissionCheck('survey.survey_update')): ?>
                                                                <a href="<?php echo e(route('survey.survey_edit', $survey->id)); ?>"
                                                                   class="dropdown-item editStudent"
                                                                   type="button"><?php echo e(__('common.Edit')); ?></a>
                                                            <?php endif; ?>
                                                            <?php if($survey->participants->count()==0): ?>
                                                                <?php if(permissionCheck('survey.survey_delete')): ?>
                                                                    <a onclick="confirm_modal('<?php echo e(route('survey.survey_delete', $survey->id)); ?>');"
                                                                       class="dropdown-item edit_brand"><?php echo e(__('common.Delete')); ?></a>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                            <?php if(permissionCheck('survey.question_assign')): ?>
                                                                <a href="<?php echo e(route('survey.question_assign', $survey->id)); ?>"
                                                                   class="dropdown-item editStudent" type="button">Set
                                                                    Question</a>

                                                            <?php endif; ?>
                                                            <?php if(permissionCheck('survey.survey_participants')): ?>

                                                                <a href="<?php echo e(route('survey.survey_participants', $survey->id)); ?>"
                                                                   class="dropdown-item editStudent"
                                                                   type="button"><?php echo e(__('survey.Participants')); ?></a>
                                                            <?php endif; ?>
                                                            <?php if(permissionCheck('survey.user_based_report')): ?>
                                                                <a href="<?php echo e(route('survey.user_based_report', $survey->id)); ?>"
                                                                   class="dropdown-item editStudent" type="button">User
                                                                    based report</a>

                                                            <?php endif; ?>
                                                            <?php if(permissionCheck('survey.question_based_report')): ?>
                                                                <a href="<?php echo e(route('survey.question_based_report', $survey->id)); ?>"
                                                                   class="dropdown-item editStudent" type="button">Question
                                                                    based report</a>

                                                            <?php endif; ?>
                                                            <?php if(permissionCheck('survey.question_based_graph')): ?>
                                                                <a href="<?php echo e(route('survey.question_based_graph', $survey->id)); ?>"
                                                                   class="dropdown-item editStudent"
                                                                   type="button">Graph</a>

                                                            <?php endif; ?>


                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>
    <input type="hidden" name="status_route" class="status_route" value="<?php echo e(route('coupons.status_update')); ?>">

    <?php echo $__env->make('backend.partials.delete_modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script type="application/javascript">
        (function ($) {
            "use strict";

            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4, 5]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/Survey/Resources/views/index.blade.php ENDPATH**/ ?>