<?php use Illuminate\Support\Facades\Storage; ?>
<div role="tabpanel" class="tab-pane fade"
     id="fcm">
    <?php if(permissionCheck('api.setting')): ?>
        <form class="form-horizontal" action="<?php echo e(route('save.api.setting')); ?>"
              method="POST" enctype="multipart/form-data">
            <?php endif; ?>
            <?php echo csrf_field(); ?>
            <div>
                <div class="col-md-12 ">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-lg-12 mb-10">

                                    <label class="primary_input_label"
                                           for=""><?php echo e(__('setting.FCM Admin SDK JSON File')); ?></label>
                                    <div class="primary_file_uploader">
                                        <input
                                            class="primary-input filePlaceholder"
                                            type="text"
                                            accept="application/json"
                                            placeholder="<?php echo e(__('common.Browse')); ?> <?php echo e(__('setting.FCM Admin SDK JSON File')); ?>"
                                            readonly="">
                                        <button class="" type="button">
                                            <label
                                                class="primary-btn small fix-gr-bg"
                                                for="document_file_public_key_<?php echo e(@$payment_method->id); ?>"><?php echo e(__('common.Browse')); ?></label>
                                            <input type="file"
                                                   class="d-none fileUpload"
                                                   name="fcm_json"
                                                   accept="application/json"
                                                   id="document_file_public_key_<?php echo e(@$payment_method->id); ?>"
                                            >
                                        </button>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <code><a target="_blank"
                                             title=""
                                             href="https://console.firebase.google.com/"><?php echo e(__('setting.Click Here to Get Firebase Cloud Messaging(FCM) Api Credentials')); ?></a></code>
                                </div>

                                <div class="col-lg-12 text-center">
                                    <button type="submit" class="primary-btn fix-gr-bg">
                                        <i class="ti-check"></i>
                                        <?php echo e(__('common.Update')); ?>

                                    </button>
                                </div>


                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </form>
        <hr>

        <?php

            $json = Storage::get(SaasDomain() . '-firebase-service-account.json');
               $data = json_decode($json, true);
        ?>
        <?php if($data): ?>
            <div class="row mt-3">
                <div class="col-lg-6 mb-10">
                    <div class="input-effect">
                        <label class="pb-2"><?php echo e(__('setting.FCM Project ID')); ?>

                        </label>
                        <input class="primary_input_field form-control"
                               type="text" name="fcm_project_id"
                               autocomplete="off"
                               value="<?php echo e($data['project_id']??''); ?>">
                    </div>
                </div>

                <div class="col-lg-6 mb-10">
                    <div class="input-effect">
                        <label class="pb-2"><?php echo e(__('setting.FCM Client Email')); ?>

                        </label>
                        <input class="primary_input_field form-control"
                               type="text" name="fcm_client_email"
                               autocomplete="off"
                               value="<?php echo e($data['client_email']??''); ?>">
                    </div>
                </div>


                <div class="col-lg-12 mb-10">
                    <div class="input-effect">
                        <label class="pb-2"><?php echo e(__('setting.FCM Private Key')); ?>

                        </label>
                        <textarea rows="15" class=" form-control"
                                  name="fcm_private_key"><?php echo $data['private_key']??''; ?></textarea>
                    </div>
                </div>
            </div>
        <?php endif; ?>
</div>
<?php /**PATH /home/minialms/card.minialms.com/Modules/SystemSetting/Providers/../Resources/views/api/partials/_fcm.blade.php ENDPATH**/ ?>