<div class="modal-dialog modal-dialog-centered student-details">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">
                <?php if($edit): ?>
                    <?php echo e(__('common.Edit')); ?>

                <?php else: ?>
                    <?php echo e(__('common.Add')); ?>

                <?php endif; ?>
                <?php echo e(__('quiz.Chapter')); ?>

            </h4>
            <button type="button" class="btn-close" data-bs-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">

            <?php if($edit): ?>
                <form class="form-horizontal" method="POST" action="<?php echo e(route('updateChapter')); ?>"
                      enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <input type="hidden" name="chapter"
                           value="<?php echo e($edit->id); ?>">
                    <?php else: ?>
                        <form class="form-horizontal" method="POST" action="<?php echo e(route('saveChapter')); ?>"
                              enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php endif; ?>

                            <input type="hidden" id="url" value="<?php echo e(url('/')); ?>">
                            <input type="hidden" name="course_id" value="<?php echo e(@$course_id); ?>">
                            <input type="hidden" name="input_type" value="1">
                            <input type="hidden" name="is_lock" value="1">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="input-effect mt-2 pt-1 mb-20">
                                        <label
                                            class="primary_input_label mt-1"><?php echo e(__('quiz.Chapter')); ?> <?php echo e(__('common.Name')); ?>

                                            <span class="required_mark">*</span></label>
                                        <input
                                            class="primary_input_field name<?php echo e($errors->has('chapter_name') ? ' is-invalid' : ''); ?>"
                                            type="text" name="chapter_name" placeholder="<?php echo e(__('common.Title')); ?>"
                                            autocomplete="off"
                                            value="<?php echo e($edit?$edit->name:''); ?>">
                                        <span class="focus-border"></span>
                                        <?php if($errors->has('chapter_name')): ?>
                                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('chapter_name')); ?></strong>
                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div class=" d-flex justify-content-between">
                                <button type="button" class="primary-btn tr-bg"
                                        data-bs-dismiss="modal"><?php echo app('translator')->get('common.Cancel'); ?></button>

                                <button class="primary-btn fix-gr-bg"
                                        type="submit">
                                    <i class="ti-check"></i>
                                    <?php echo app('translator')->get('common.Submit'); ?></button>
                            </div>
                        </form>

        </div>
    </div>

</div>

<?php /**PATH /home/minialms/card.minialms.com/Modules/CourseSetting/Providers/../Resources/views/parts_of_course_details/modal/_chapter.blade.php ENDPATH**/ ?>