<?php $__env->startSection('table'); ?>
    <?php echo e(__('social_links')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('mainContent'); ?>
    <?php echo generateBreadcrumb(); ?>

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row row-gap-24 justify-content-center">
                <div class="col-xxl-3">
                    <div class="white-box ">
                    <div class="row justify-content-center">
                            <div class="col-12">
                                <div class="box_header common_table_header">
                                    <div class="main-title d-md-flex">
                                        <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">
                                            <?php if(!isset($edit)): ?>
                                                <?php echo e(__('common.Add New')); ?>

                                            <?php else: ?>
                                                <?php echo e(__('common.Update')); ?>

                                            <?php endif; ?></h3>
                                        <?php if(isset($edit)): ?>
                                            <?php if(permissionCheck('frontend.socialSetting.store')): ?>
                                                <a href="<?php echo e(url('frontend/social-setting')); ?>"
                                                   class="primary-btn small fix-gr-bg updateBtn"
                                                   title=" <?php echo e(__('frontendmanage.Add')); ?>">+</a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php if(isset($edit)): ?>
                            <form action="<?php echo e(route('frontend.socialSetting.update')); ?>" method="post" id="coupon-form"
                                  name="coupon-form" enctype="multipart/form-data">
                                <?php else: ?>
                                    <?php if(permissionCheck('frontend.socialSetting.store')): ?>
                                        <form action="<?php echo e(route('frontend.socialSetting.store')); ?>" method="POST"
                                              id="coupon-form" name="coupon-form" enctype="multipart/form-data">
                                            <?php endif; ?>
                                            <?php endif; ?>
                                            <?php echo csrf_field(); ?>
                                            <?php if(isset($edit)): ?>
                                                <input type="hidden" name="id"
                                                       value="<?php echo e($edit->id); ?>">
                                            <?php endif; ?>
                                            <input type="hidden" name="category" value="1">
                                            <div class="row">


                                                <div class="col-xl-12">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label"
                                                               for=""><?php echo e(__('frontendmanage.Icon')); ?> <strong
                                                                class="text-danger">*</strong></label>
                                                        <select
                                                            class="primary_select mb-25  <?php echo e(@$errors->has('icon') ? ' is-invalid' : ''); ?>"
                                                            name="icon" id="icon" required>
                                                            <?php if(isset($edit)): ?>
                                                                <option value="<?php echo e(@$edit->icon); ?>"
                                                                        selected><?php echo e(@$edit->icon); ?></option>
                                                            <?php endif; ?>
                                                            <?php echo socialIconList(); ?>

                                                        </select>
                                                    </div>
                                                </div>


                                                <div class="col-xl-12">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label"
                                                               for=""><?php echo e(__('frontendmanage.Enter social  link')); ?>

                                                            <strong class="text-danger">*</strong></label>
                                                        <input name="btn_link" id="btn_link"
                                                               class="primary_input_field name <?php echo e(@$errors->has('btn_link') ? ' is-invalid' : ''); ?>"
                                                               placeholder="<?php echo e(__('frontendmanage.Enter social  link')); ?>"
                                                               type="text"
                                                               value="<?php echo e(isset($edit)?$edit->link:old('btn_link')); ?>">
                                                        <?php if($errors->has('btn_link')): ?>
                                                            <span class="invalid-feedback d-block mb-10" role="alert">
                                            <strong><?php echo e(@$errors->first('btn_link')); ?></strong>
                                        </span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <div class="col-xl-12">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label"
                                                               for=""><?php echo e(__('frontendmanage.Social Name')); ?> <strong
                                                                class="text-danger">*</strong></label>
                                                        <input name="name" id="btn_link"
                                                               class="primary_input_field name <?php echo e(@$errors->has('name') ? ' is-invalid' : ''); ?>"
                                                               placeholder="<?php echo e(__('frontendmanage.Social Name')); ?>"
                                                               type="text"
                                                               value="<?php echo e(isset($edit)?$edit->name:old('name')); ?>">
                                                        <?php if($errors->has('name')): ?>
                                                            <span class="invalid-feedback d-block mb-10" role="alert">
                                            <strong><?php echo e(@$errors->first('name')); ?></strong>
                                        </span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <div class="col-xl-12">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label"
                                                               for=""><?php echo e(__('common.Status')); ?></label>
                                                        <select
                                                            class="primary_select mb-25  <?php echo e(@$errors->has('status') ? ' is-invalid' : ''); ?>"
                                                            name="status" id="status" required>
                                                            <option
                                                                value="1" <?php echo e(isset($edit)?($edit->status==1?'selected':''):''); ?>><?php echo e(__('common.Active')); ?></option>
                                                            <option
                                                                value="0" <?php echo e(isset($edit)?($edit->status==0?'selected':''):''); ?>><?php echo e(__('common.Inactive')); ?></option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <?php
                                                    $tooltip = "";
                                                      if(permissionCheck('frontend.socialSetting.store')){
                                                          $tooltip = "";
                                                      }else{
                                                          $tooltip = "You have no permission to add";
                                                      }
                                                ?>
                                                <div class="col-lg-12 text-center">
                                                    <div class="d-flex justify-content-center pt_20">
                                                        <button type="submit" class="primary-btn semi_large fix-gr-bg"
                                                                data-bs-toggle="tooltip" title="<?php echo e($tooltip); ?>"
                                                                id="save_button_parent">
                                                            <i class="ti-check"></i>
                                                            <?php if(!isset($edit)): ?>
                                                                <?php echo e(__('common.Save')); ?>

                                                            <?php else: ?>
                                                                <?php echo e(__('common.Update')); ?>

                                                            <?php endif; ?>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                    </div>
                </div>
                <div class="col-xxl-9">

                    <div class="white-box">
                        <div class="box_header common_table_header">
                            <div class="main-title d-flex flex-wrap mb-0">
                                <h3 class="mb-0" id="page_title"><?php echo e(__('frontendmanage.Social Setting')); ?> </h3>
                            </div>
                        </div>
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col"><?php echo e(__('common.SL')); ?></th>
                                            <th scope="col"><?php echo e(__('frontendmanage.Icon')); ?></th>
                                            <th scope="col"><?php echo e(__('frontendmanage.Link')); ?></th>
                                            <th scope="col"><?php echo e(__('frontendmanage.Social Name')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Status')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Action')); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>


                                        <?php $__currentLoopData = $data['social_links']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th><?php echo e(translatedNumber($key+1)); ?></th>
                                                <td><i class="<?php echo e(@$item->icon); ?>"></i></td>
                                                <td><?php echo e($item->link); ?></td>
                                                <td><?php echo e($item->name); ?></td>
                                                <td>
                                                    <label class="switch_toggle"
                                                           for="status_enable_disable<?php echo e($item->id); ?>">
                                                        <input type="checkbox" id="status_enable_disable<?php echo e($item->id); ?>"
                                                               class="<?php if(permissionCheck('frontend.socialSetting.status_update')): ?> status_enable_disable <?php endif; ?>"
                                                               <?php if($item->status == 1): ?> checked
                                                               <?php endif; ?> value="<?php echo e($item->id); ?>">
                                                        <i class="slider round"></i>
                                                    </label>
                                                </td>
                                                <td>
                                                    <!-- shortby  -->
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu2" data-bs-toggle="dropdown"
                                                                aria-haspopup="true" aria-expanded="false">
                                                            <?php echo e(__('common.Select')); ?>

                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu2">
                                                            <?php if(permissionCheck('frontend.socialSetting.edit')): ?>
                                                                <a href="<?php echo e(route('frontend.socialSetting_edit',$item->id)); ?>"
                                                                   class="dropdown-item edit_brand"><?php echo e(__('common.Edit')); ?></a>
                                                            <?php endif; ?>
                                                            <?php if(permissionCheck('frontend.socialSetting.delete')): ?>
                                                                <a onclick="confirm_modal('<?php echo e(route('frontend.socialSetting.delete', $item->id)); ?>');"
                                                                   class="dropdown-item edit_brand"><?php echo e(__('common.Delete')); ?></a>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                    <!-- shortby  -->
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php echo $__env->make('backend.partials.delete_modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script type="application/javascript">


        dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 2, 3]);

        let table = $('#lms_table').DataTable(dataTableOptions);


    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/FrontendManage/Resources/views/socialSetting.blade.php ENDPATH**/ ?>