<?php
    $table_name='blog_categories';
?>
<?php $__env->startSection('table'); ?>
    <?php echo e($table_name); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('mainContent'); ?>
    <?php
        $LanguageList = getLanguageList();
    ?>
    <?php echo generateBreadcrumb(); ?>

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-xxl-3">
                    <div class="white-box mb_30 student-details header-menu">
                        <div class="box_header common_table_header">
                            <div class="main-title d-flex flex-wrap mb-0">
                                <h3 class="mb-0"> <?php if(!isset($edit)): ?>
                                        <?php echo e(__('courses.Add New Category')); ?>

                                    <?php else: ?>
                                        <?php echo e(__('courses.Update Category')); ?>

                                    <?php endif; ?></h3>
                                <?php if(isset($edit)): ?>
                                    <a href="<?php echo e(route('blog-category.store')); ?>"
                                       class="primary-btn small fix-gr-bg ms-4" style="line-height: 25px;"
                                       title="<?php echo e(__('courses.Add New')); ?>">+</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="row pt-0">
                            <?php if(isModuleActive('FrontendMultiLang')): ?>
                                <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3"
                                    role="tablist">
                                    <?php $__currentLoopData = $LanguageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item">
                                            <a class="nav-link  <?php if(auth()->user()->language_code == $language->code): ?> active <?php endif; ?>"
                                               href="#element<?php echo e($language->code); ?>"
                                               role="tab"
                                               data-bs-toggle="tab"><?php echo e($language->native); ?>  </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                        <?php if(isset($edit)): ?>
                            <?php if(permissionCheck('blog-category.update')): ?>
                                <form action="<?php echo e(route('blog-category.update')); ?>" method="POST" id="category-form"
                                      name="category-form" enctype="multipart/form-data">
                                    <input type="hidden" name="id"
                                           value="<?php echo e($edit->id); ?>">
                                    <?php endif; ?>
                                    <?php else: ?>
                                        <?php if(permissionCheck('blog-category.store')): ?>
                                            <form action="<?php echo e(route('blog-category.store')); ?>" method="POST"
                                                  id="category-form" name="category-form" enctype="multipart/form-data">
                                                <?php endif; ?>
                                                <?php endif; ?>
                                                <?php echo csrf_field(); ?>


                                                <div class="tab-content">
                                                    <?php $__currentLoopData = $LanguageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div role="tabpanel"
                                                             class="tab-pane fade <?php if(auth()->user()->language_code == $language->code): ?> show active <?php endif; ?>  "
                                                             id="element<?php echo e($language->code); ?>">
                                                            <div class="row">
                                                                <div class="col-xl-12">
                                                                    <div class="primary_input mb-25">
                                                                        <label class="primary_input_label"
                                                                               for="nameInput"><?php echo e(__('common.Title')); ?>

                                                                            <strong
                                                                                class="text-danger">*</strong></label>
                                                                        <input name="title[<?php echo e($language->code); ?>]"
                                                                               id="nameInput"

                                                                               class="primary_input_field name <?php echo e(@$errors->has('title') ? ' is-invalid' : ''); ?>"
                                                                               placeholder="<?php echo e(__('common.Title')); ?>"
                                                                               type="text"
                                                                               value="<?php echo e(isset($edit)?$edit->getTranslation('title',$language->code):old('title.'.$language->code)); ?>" <?php echo e($errors->has('title') ? 'autofocus' : ''); ?>>
                                                                        <?php if($errors->has('title')): ?>
                                                                            <span class="invalid-feedback d-block mb-10"
                                                                                  role="alert">
                                                                <strong><?php echo e(@$errors->first('title')); ?></strong>
                                                            </span>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                            </div>


                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                                <div class="row">


                                                    <div class="col-xl-12">
                                                        <div class="primary_input mb-25">
                                                            <label class="primary_input_label"
                                                                   for="parent"><?php echo e(__('common.Parent')); ?></label>
                                                            <select class="primary_select mb-25" name="parent"
                                                                    id="parent">
                                                                <option value=""><?php echo e(__('common.None')); ?></option>
                                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php if(isset($edit) && $category->id==$edit->id): ?>
                                                                        <?php
                                                                            continue;
                                                                        ?>
                                                                    <?php endif; ?>
                                                                    <option
                                                                        value="<?php echo e($category->id); ?>"
                                                                        <?php echo e(isset($edit)?($edit->parent_id==$category->id?'selected':old('parent')):old('parent')); ?>

                                                                    ><?php echo e($category->title); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="col-xl-12">
                                                        <div class="primary_input mb-25">
                                                            <label class="primary_input_label"
                                                                   for="position_order"><?php echo e(__('courses.Position')); ?></label>


                                                            <input name="position_order"
                                                                   class="primary_input_field name <?php echo e(@$errors->has('position_order') ? ' is-invalid' : ''); ?>"
                                                                   placeholder="<?php echo e(__('courses.Position Order')); ?>"
                                                                   type="number"
                                                                   value="<?php echo e(isset($edit)?$edit->position_order:old('position_order',$max_id)); ?>" <?php echo e($errors->has('position_order') ? 'autofocus' : ''); ?>>
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-12 text-center">
                                                        <div class="d-flex justify-content-center pt_20">
                                                            <button type="submit"
                                                                    class="primary-btn semi_large fix-gr-bg"
                                                                    data-bs-toggle="tooltip"
                                                                    id="save_button_parent">
                                                                <i class="ti-check"></i>
                                                                <?php if(!isset($edit)): ?>
                                                                    <?php echo e(__('common.Save')); ?>

                                                                <?php else: ?>
                                                                    <?php echo e(__('common.Update')); ?>

                                                                <?php endif; ?>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>

                                            </form>
                    </div>
                </div>
                <div class="col-xxl-9">
                    <div class="white-box">
                        <div class="box_header common_table_header">
                            <div class="main-title d-flex flex-wrap mb-0">
                                <h3 class="mb-0" id="page_title"><?php echo e(__('courses.Category List')); ?></h3>
                            </div>
                        </div>
                        <div class="  QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col"><?php echo e(__('common.SL')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Name')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Parent')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Position')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Status')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Action')); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e(translatedNumber(++$key)); ?></td>
                                                <td>
                                                    <?php echo e(checkParent($category)); ?>

                                                    <?php echo e(@$category->title); ?></td>
                                                <td><?php echo e(@$category->parent->title); ?></td>
                                                <td><?php echo e(@translatedNumber($category->position_order)); ?></td>

                                                <td class="nowrap">
                                                    <?php if(permissionCheck('blog-category.changeStatus')): ?>
                                                        <label class="switch_toggle"
                                                        >
                                                            <input type="checkbox"
                                                                   class="<?php if(permissionCheck('blog-category.status_update')): ?>  status_enable_disable <?php endif; ?> "
                                                                   <?php if(@$category->status == 1): ?> checked
                                                                   <?php endif; ?> value="<?php echo e(@$category->id); ?>">
                                                            <i class="slider round"></i>
                                                        </label>
                                                    <?php else: ?>
                                                        <?php echo e($category->status == 1?trans('common.Active'):trans('common.Inactive')); ?>

                                                    <?php endif; ?>
                                                </td>

                                                <td>

                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle"
                                                                type="button"
                                                                id="dropdownMenu1<?php echo e(@$category->id); ?>"
                                                                data-bs-toggle="dropdown"
                                                                aria-haspopup="true"
                                                                aria-expanded="false">
                                                            <?php echo e(__('common.Select')); ?>

                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu1<?php echo e(@$category->id); ?>">
                                                            <?php if(permissionCheck('blog-category.update')): ?>
                                                                <a class="dropdown-item edit_brand"
                                                                   href="<?php echo e(route('blog-category.edit',$category->id)); ?>"><?php echo e(__('common.Edit')); ?></a>
                                                            <?php endif; ?>
                                                            <?php if(permissionCheck('blog-category.destroy')): ?>
                                                                <a onclick="confirm_modal('<?php echo e(route('blog-category.destroy', $category->id)); ?>');"
                                                                   class="dropdown-item edit_brand"><?php echo e(__('common.Delete')); ?></a>
                                                            <?php endif; ?>

                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php echo $__env->make('backend.partials.delete_modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script type="application/javascript">


        dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3]);

        let table = $('#lms_table').DataTable(dataTableOptions);


    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/Blog/Resources/views/category.blade.php ENDPATH**/ ?>