@extends('backend.master')
@section('mainContent')
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="">
                        <div class="row">
                            <div class="col-lg-12 mt-4">
                                <div class="white_box_30px">
                                    <!-- SMTP form  -->
                                    <div class="main-title mb-25">
                                        <h3 class="mb-3">{{ __('whatsapp.update_agent') }}</h3>
                                    </div>
                                    <form action="{{ route('whatsapp-support.agents.update') }}" method=POST
                                          enctype=multipart/form-data>
                                        @csrf
                                        <div class="row" id="pusher">
                                            <div class="col-xl-12 mb-4">
                                                <label class="primary_input_label mb-3">{{ __('common.Type') }}
                                                    <span class="required_mark">*</span></label>
                                                <div class="d-flex radio-btn-flex">
                                                    <div class="me-3">
                                                        <input type="radio"   name="type" required
                                                               id="relationType1" value="1"
                                                               {{$agent->type==1?'checked':''}}
                                                               class="common-radio relationButton typeInput">
                                                        <label
                                                            for="relationType1">{{ __('whatsapp.Whatsapp') }}</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="type" id="relationType2" value="2"
                                                               {{$agent->type==2?'checked':''}}
                                                               class="common-radio relationButton typeInput">
                                                        <label
                                                            for="relationType2">{{ __('whatsapp.Website URL') }}</label>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="col-xl-6 mt-4">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{ __('whatsapp.name') }} *</label>
                                                    <input class="primary_input_field" name="name" type="text"
                                                           value="{{ $agent->name }}">
                                                </div>
                                            </div>

                                            <div class="col-xl-6 mt-4">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{ __('whatsapp.designation') }}
                                                        *</label>
                                                    <input class="primary_input_field" name="designation" type="text"
                                                           value="{{ $agent->designation }}">
                                                </div>
                                            </div>


                                            <div class="col-xl-6 mb-4 {{$agent->type==2?'':'d-none'}}" id="typeURL">
                                                <div class="primary_input ">
                                                    <label class="primary_input_label"
                                                           for="">{{ __('whatsapp.URL') }}
                                                        <span class="required_mark">*</span></label>
                                                    <input class="primary_input_field" name="url" type="text"
                                                           value="{{$agent->url}}"
                                                    >
                                                </div>
                                            </div>

                                            <div class="col-xl-6 mt-4 {{$agent->type==1?'':'d-none'}}" id="typeWhatsapp">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{ __('whatsapp.number') }} * (<small
                                                            class="text-danger">{{ __('whatsapp.with_country_code') }}</small>)</label>
                                                    <input class="primary_input_field" name="number" type="text"
                                                           value="{{ $agent->number }}">
                                                </div>
                                            </div>

                                            <div class="col-xl-6 mt-4">
                                                <div class="  mb-25">
                                                    <x-upload-file
                                                        name="avatar"
                                                        type="image"
                                                        media_id="{{isset($agent)?$agent->avater_media?->media_id:''}}"
                                                        label="{{ __('whatsapp.avatar') }}"
                                                    />

                                                </div>
                                            </div>

                                            <div class="col-xl-6 mt-4">
                                                <p class="primary_input_label">{{ __('whatsapp.status') }}
                                                    *</p>
                                                <div class="d-flex radio-btn-flex">
                                                    <div class="me-3">
                                                        <input type="radio" name="status"
                                                               {{ $agent->status ? 'checked' : '' }} required
                                                               id="relationFather3" value="1"
                                                               class="common-radio relationButton">
                                                        <label
                                                            for="relationFather3">{{ __('whatsapp.active') }}</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="status"
                                                               {{ !$agent->status ? 'checked' : '' }} id="relationMother4"
                                                               value="0" class="common-radio relationButton">
                                                        <label
                                                            for="relationMother4">{{ __('whatsapp.inactive') }}</label>
                                                    </div>
                                                    @error('status') <small
                                                        class="text-danger font-italic">*{{ $message }}</small> @enderror
                                                </div>
                                            </div>

                                            <div class="col-xl-6 mt-4">
                                                <p class="primary_input_label">{{ __('whatsapp.always_available') }}
                                                    *</p>
                                                <div class="d-flex radio-btn-flex">
                                                    <div class="me-3">
                                                        <input type="radio" name="always_available"
                                                               {{ $agent->always_available ? 'checked' : '' }} required
                                                               id="relationFather33333" value="1"
                                                               class="common-radio relationButton" checked>
                                                        <label
                                                            for="relationFather33333">{{ __('whatsapp.yes') }}</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="always_available"
                                                               {{ !$agent->always_available ? 'checked' : '' }} id="relationMother4433"
                                                               value="0" class="common-radio relationButton">
                                                        <label
                                                            for="relationMother4433">{{ __('whatsapp.no') }}</label>
                                                    </div>
                                                    @error('always_available') <small
                                                        class="text-danger font-italic">*{{ $message }}</small> @enderror
                                                </div>
                                                <input type="hidden" name="agent_id" value="{{ $agent->id }}">
                                            </div>

                                            <div class="col-xl-6 mt-4">
                                                <h4>Time : </h4>
                                                @foreach(\Carbon\Carbon::getDays() as $index => $day)
                                                    <div class="row g-0  input-right-icon mt-25 align-items-center row-gap-24">
                                                        <div class="col-md-3">
                                                            <div class="input-effect">
                                                                <input
                                                                    {{ $agent->times->contains('day', $day) ? 'checked' : '' }} type="checkbox"
                                                                    id="isBreak{{ $index }}"
                                                                    class="common-checkbox read-only-input"
                                                                    value="{{$day}}" name="day[]">
                                                                <label for="isBreak{{ $index }}">{{ $day }}</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <div class="col">
                                                                <div class="input-effect">
                                                                    <input
                                                                        value="{{ $agent->times->where('day', $day)->first()->start ?? ''}}"
                                                                        id="agent_start{{$index}}"
                                                                        class="primary-input time form-control has-content"
                                                                        type="text" name="start[]">
                                                                    <label class="primary_input_label mt-1">Start Time</label>
                                                                    <span class="focus-border"></span>
                                                                </div>
                                                            </div>
                                                            <div class="col-auto">
                                                                <button class="" type="button">
{{--                                                                    <i class="ti-timer"></i>--}}
                                                                </button>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <div class="col">
                                                                <div class="input-effect">
                                                                    <input id="agent_end{{$index}}"
                                                                           value="{{ $agent->times->where('day', $day)->first()->end ?? ''}}"
                                                                           class="primary-input time form-control has-content"
                                                                           type="text" name="end[]">
                                                                    <label class="primary_input_label mt-1">End Time</label>
                                                                    <span class="focus-border"></span>
                                                                </div>
                                                            </div>
                                                            <div class="col-auto">
                                                                <button class="" type="button">
{{--                                                                    <i class="ti-timer"></i>--}}
                                                                </button>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            @if($index == 0)
                                                                <p onclick="setTimeToAll()"
                                                                   class="primary-btn radius_30px w-fit fix-gr-bg ms-3">Apply
                                                                    All Days</p>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="d-flex align-content-center justify-content-center">
                                            <button class="primary-btn   fix-gr-bg mt-4" type="submit"><i
                                                    class="ti-check"></i>{{ __('whatsapp.update') }}
                                            </button>
                                        </div>

                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('scripts')
    <script type="application/javascript">

        {{-- docment ready--}}
        $(document).ready(function () {
            $(document).on('click', '.typeInput', function () {
                let whatsappType=$('#typeWhatsapp');
                let urlType=$('#typeURL');

                if ($(this).val() == 1) {
                    whatsappType.removeClass('d-none');
                    urlType.addClass('d-none');
                }else{

                    whatsappType.addClass('d-none');
                    urlType.removeClass('d-none');
                }
            })
        })
    </script>
@endpush
