<?php

namespace Modules\UpcomingCourse\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Bryceandy\Laravel_Pesapal\Facades\Pesapal;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Modules\BankPayment\Http\Controllers\BankPaymentController;
use Modules\CourseSetting\Entities\Course;
use Modules\Instamojo\Http\Controllers\InstamojoController;
use Modules\Midtrans\Http\Controllers\MidtransController;
use Modules\Mobilpay\Http\Controllers\MobilpayController;
use Modules\Payeer\Http\Controllers\PayeerController;
use Modules\Paytm\Http\Controllers\PaytmController;
use Modules\Razorpay\Http\Controllers\RazorpayController;
use Modules\Sslcommerz\Http\Controllers\SslcommerzController;
use Modules\UpcomingCourse\Entities\UpcomingCourseBooking;
use Modules\UpcomingCourse\Entities\UpcomingCourseBookingPayment;
use Modules\Wallet\Http\Controllers\WalletController;
use Omnipay\Omnipay;
use Unicodeveloper\Paystack\Facades\Paystack;

class PrebookingController extends Controller
{


    public $payPalGateway;

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware(['maintenanceMode', 'onlyAppMode']);
        $this->payPalGateway = Omnipay::create('PayPal_Rest');
        $this->payPalGateway->setClientId(getPaymentEnv('PAYPAL_CLIENT_ID'));
        $this->payPalGateway->setSecret(getPaymentEnv('PAYPAL_CLIENT_SECRET'));
        $this->payPalGateway->setTestMode(getPaymentEnv('IS_PAYPAL_LOCALHOST') == 'true'); //set it to 'false' when go live
    }

    public function prebooking($id)
    {
        try {
            $id = decrypt($id);
            $course = Course::find($id);
            if ($course && $course->is_upcoming_course && $course->is_allow_prebooking) {

                if ($course->discount_price != null) {
                    $price = $course->discount_price;
                } else {
                    $price = $course->price;
                }
                if ($price == 0 || $course->booking_amount == 0) {


                    $booking = UpcomingCourseBooking::create([
                        'course_id' => $id,
                        'user_id' => Auth::id(),
                    ]);

                    Toastr::success(trans('frontend.Payment done successfully'), trans('common.Success'));
                    return redirect()->back();
                }

            }

            $pre_booking_session = 'prebooking_' . Auth::id();
            session([$pre_booking_session => $id]);

            return view(theme('pages.pre_booking'), compact('id'));

        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function bookingSubmit(Request $request)
    {
        $data = $request->validate([
            'deposit_amount' => 'required|numeric',
            'method' => 'required',
            'course_id' => 'required',
        ]);

        $pre_booking_session = 'prebooking_' . Auth::id();

        session([$pre_booking_session => $request->course_id]);

        if (Settings('hide_multicurrency') == 1) {
            $amount = (float)number_format(convertCurrency(auth()->user()->currency->code ?? Settings('currency_code'), Settings('currency_code'), $data['deposit_amount']), 2);
        } else {
            $amount = $data['deposit_amount'];
        }
        $request->merge([
            "deposit_amount" => $amount
        ]);

        $data['deposit_amount'] = $amount;


        if ($data['method'] == "Sslcommerz") {
            $ssl = new SslcommerzController();
            $ssl->deposit($data['deposit_amount']);

        } elseif ($data['method'] == "PayPal") {


            $response = $this->payPalGateway->purchase(array(
                'amount' => $data['deposit_amount'],
                'currency' => Settings('currency_code'),
                'returnUrl' => route('paypalBookingSuccess'),
                'cancelUrl' => route('paypalBookingFailed'),

            ))->send();


            if ($response->isRedirect()) {
                $response->redirect();
            } else {
                Toastr::error($response->getMessage(), trans('common.Failed'));
                return \redirect()->back();
            }
        } elseif ($data['method'] == "Wallet") {

            $payment = new WalletController();
            $response = $payment->booking($request);

            if ($response['type'] == "error") {
                Toastr::error($response['message'], trans('common.Error'));
                return \redirect()->back();
            }

            $payWithWallet = $this->bookingWithGateWay($request->deposit_amount, $response['response'], "Wallet", $user = null,);

            if ($payWithWallet) {
                Toastr::success(trans('frontend.Payment done successfully'), trans('common.Success'));
                if (Settings('frontend_active_theme') == 'tvt') {
                    return redirect('/');
                }

                return redirect(route('studentDashboard'));
            } else {
                Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                return \redirect()->back();
            }

        } elseif ($data['method'] == "Midtrans") {

            try {
                $midtrans = new MidtransController();
                $request->merge(['type' => 'prebooking']);
                $response = $midtrans->makePayment($request);

                if ($response) {
                    return $response;
                } else {
                    Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                    return \redirect()->back();
                }
            } catch (\Exception $e) {
                GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());

            }


        } elseif ($data['method'] == "Payeer") {

            try {
                $payeer = new PayeerController();
                $request->merge(['type' => 'prebooking']);
                $response = $payeer->makePayment($request);
                if ($response) {
                    return \redirect()->to($response);
                } else {
                    Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                    return \redirect()->back();
                }
            } catch (\Exception $e) {
                GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());

            }


        } elseif ($data['method'] == "MercadoPago") {
            $mercadoPagoController = new MercadoPagoController();
            $response = $mercadoPagoController->payment($request->all());
            return response()->json(['target_url' => $response]);
        } elseif ($data['method'] == "Instamojo") {
            $instamojo = new InstamojoController();
            $response = $instamojo->depositProcess($request);
            if ($response) {
                return \redirect()->to($response);
            } else {
                Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                return \redirect()->back();
            }

        } elseif ($data['method'] == "Stripe") {

            if (empty($request->get('stripeToken'))) {
                Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                return redirect(route('studentDashboard'));
            }

            $token = $request->stripeToken;
            $gatewayStripe = Omnipay::create('Stripe');
            $gatewayStripe->setApiKey(getPaymentEnv('STRIPE_SECRET'));


            $response = $gatewayStripe->purchase(array(
                'amount' => $data['deposit_amount'],
                'currency' => Settings('currency_code'),
                'token' => $token,
            ))->send();

            if ($response->isRedirect()) {
                // redirect to offsite payment gateway
                $response->redirect();
            } elseif ($response->isSuccessful()) {
                // payment was successful: update database

                $amount = number_format($response->getData()['amount'] / 100, 2);

                $payWithStripe = $this->bookingWithGateWay($amount, $response, "Stripe");
                if ($payWithStripe) {
                    Toastr::success(trans('frontend.Payment done successfully'), trans('common.Success'));
                    return redirect(route('studentDashboard'));
                } else {
                    Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                    return redirect(route('studentDashboard'));
                }

            } else {

                if ($response->getCode() == "amount_too_small") {
                    $amount = number_format(convertCurrency(Settings('currency_code'), strtoupper(Settings('currency_code') ?? 'BDT'), 0.5), 2);
                    $message = trans('frontend')." " . Settings('currency_symbol') . ' ' . $amount;
                    Toastr::error($message, trans('common.Error'));
                } else {
                    Toastr::error($response->getMessage(), trans('common.Error'));
                }
                return redirect()->back();

            }
        } elseif ($data['method'] == "RazorPay") {

            if (empty($request->razorpay_payment_id)) {
                Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                return \redirect()->back();
            }

            $payment = new RazorpayController();
            $response = $payment->payment($request->razorpay_payment_id);
            if ($response['type'] == "error") {
                Toastr::error($response['message'], trans('common.Error'));
                return \redirect()->back();
            }


            $amount = number_format($response['response']['amount'] / 100, 2);

            $payWithRazorPay = $this->bookingWithGateWay($amount, $response['response'], "RazorPay");

            if ($payWithRazorPay) {
                Toastr::success(trans('frontend.Payment done successfully'), trans('common.Success'));
                return redirect(route('studentDashboard'));
            } else {
                Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                return redirect(route('studentDashboard'));
            }
        } elseif ($data['method'] == "PayTM") {

            $phone = Auth::user()->phone;
            $email = Auth::user()->email;
            if (empty($phone)) {
                Toastr::error(trans('frontend.Phone number is required. Please update your profile').' ', trans('common.Error'));
                return redirect()->back();
            }

            $payment = new PaytmController();
            $userData = [
                'user' => Auth::user()->id,
                'mobile' => $phone,
                'email' => $email,
                'amount' => $data['deposit_amount'],
                'order' => Auth::user()->phone . "_" . rand(1, 1000),
            ];
            return $payment->booking($userData);
        } elseif ($data['method'] == "PayStack") {
            try {
                return Paystack::getAuthorizationUrl()->redirectNow();
            } catch (\Exception $e) {
                Toastr::error(trans('frontend.Currency not supported by merchant'), trans('common.Failed'));
                return redirect()->back();
            }
        } elseif ($data['method'] == "RazerMS") {
            try {
                $payment = new RazerMSController();
                $url = $payment->generatePaymentUrl($data['deposit_amount'], 'deposit');
                return redirect($url);
            } catch (\Exception $e) {
                GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());

            }
        } elseif ($data['method'] == "Bank Payment") {


            $rules = [
                'bank_name' => 'required',
                'branch_name' => 'required',
                'type' => 'required',
                'account_number' => 'required',
                'account_holder' => 'required',
                'image' => 'mimes:jpeg,jpg,png,gif|required',
            ];
            $this->validate($request, $rules, validationMessage($rules));


            try {

                $payment = new BankPaymentController();
                $result = $payment->store($request);

                if ($result) {
                    return redirect(route('studentDashboard'));
                } else {
                    return redirect()->back();
                }

            } catch (\Exception $e) {
                GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());

            }
        } elseif ($data['method'] == "Pesapal") {
            try {
                $paymentData = [
                    'amount' => $request->deposit_amount,
                    'currency' => Settings('currency_code'),
                    'description' => 'Deposit',
                    'type' => 'MERCHANT',
                    'reference' => 'Deposit|'.md5(time()).'|' . $request->deposit_amount,
                    'first_name' => Auth::user()->first_name,
                    'last_name' => Auth::user()->last_name,
                    'email' => Auth::user()->email,
                ];

                $iframe_src = Pesapal::getIframeSource($paymentData);

                return view('laravel_pesapal::iframe', compact('iframe_src'));

            } catch (\Exception $e) {
                GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());

            }
        } elseif ($data['method'] == "Mobilpay") {
            $mobilpay = new MobilpayController();
            return $mobilpay->bookingProcess($request);

        } elseif ($data['method'] == 'Authorize.Net') {
            $authorize = new \Modules\AuthorizeNet\Repositories\AuthorizeNetRepository();
            $response = $authorize->payNow($request, $request->deposit_amount);

            if ($response != null) {
                if ($response->getMessages()->getResultCode() == "Ok") {
                    $tresponse = $response->getTransactionResponse();

                    if ($tresponse != null && $tresponse->getMessages() != null) {
                        $payWithAuthore = $this->bookingWithGateWay($request->deposit_amount, $response, 'AuthorizedNet');
                        if ($payWithAuthore) {
                            Toastr::success(trans('frontend.Payment done successfully'), trans('common.Success'));
                            if (Settings('frontend_active_theme') == 'tvt') {
                                return redirect('/');
                            }
                            return redirect(route('studentDashboard'));
                        } else {
                            Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                            return \redirect()->back();
                        }
                    } else {
                        $msg = 'here were some issue with the payment. Please try again later.';
                        if ($tresponse->getErrors() != null) {
                            $msg = $tresponse->getErrors()[0]->getErrorText();
                        }
                        Toastr::error($msg, trans('common.Failed'));
                        return Redirect::back();
                    }
                } else {
                    Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                    return Redirect::back();
                }
            } else {
                Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                return Redirect::back();
            }
        } elseif ($data['method'] == 'Braintree') {
            $braintree = new  \Modules\Braintree\Repositories\BraintreeRepository();
            $result = $braintree->payNow($request, $request->deposit_amount);
            if ($result->success) {

                $payWithBrainTree = $this->bookingWithGateWay($request->deposit_amount, $result, "Braintree");

                if ($payWithBrainTree) {
                    Toastr::success(trans('frontend.Payment done successfully'), trans('common.Success'));
                    return redirect(route('studentDashboard'));
                } else {
                    Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                    return Redirect::back();
                }
            } else {
                Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                return Redirect::back();
            }
        } elseif ($data['method'] == 'Mollie') {
            $mollie = new \Modules\Mollie\Repositories\MollieRepository();
            $pay_info = [
                'success_url' => route('molliePrebooking'),
                "order_id" => time(),
                "amount" => $request->deposit_amount,
                "details" => "Course Prebooking",
            ];
            $result = $mollie->preparePayment($pay_info);
            session()->put('mollie_id', $result->id);
            session()->put('checkout_id', $request->id);
            session()->put('tracking', $request->tracking_id);
            return redirect($result->getCheckoutUrl(), 303);
        } elseif ($data['method'] == 'Flutterwave') {
            $flutterwave = new \Modules\Flutterwave\Repositories\FlutterwaveRepository();
            $pay_info = [
                "name" => Auth::user()->name,
                "phone" => Auth::user()->phone,
                "email" => Auth::user()->email,
                "title" => "Course Prebooking",
                "description" => "Course Prebooking",
                "webhook" => route('prebookingWebhook')
            ];
            $payment = $flutterwave->PayNow($pay_info, $request->deposit_amount);
            if ($payment->status == 'success') {
                return redirect()->to($payment->data->link);
            } else {
                Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                return back();
            }
        } elseif ($data['method'] == 'Coinbase') {
        } elseif ($data['method'] == 'Jazz Cash') {
            $jazz = new \Modules\JazzCash\Repositories\JazzcashRepository();
            $payment_info = [
                "billref" => time(),
                "description" => "Prebooking Amount",
                "email" => Auth::user()->email,
                "mobile" => Auth::user()->phone,
            ];
            $result = $jazz->getArray($payment_info, $request->deposit_amount);
            $post_url = $jazz->getPostUrl();
            session()->put('from', 'prebooking');
            return view('jazzcash::payment', compact('post_url'));

        } elseif ($data['method'] == 'CCAvenue') {
        }

    }


    public static function bookingWithGateWay($amount, $response, $gateWayName, $user = null)
    {
        try {
            if (Auth::check()) {
                $user = Auth::user();
            }
            $pre_booking_session = 'prebooking_' . Auth::id();
            $course_id = session($pre_booking_session);

            if ($user && $course_id) {

                DB::beginTransaction();

                $booking = UpcomingCourseBooking::create([
                    'course_id' => $course_id,
                    'user_id' => $user->id,
                ]);

                $depositRecord = new UpcomingCourseBookingPayment();
                $depositRecord->booking_id = $booking->id;
                $depositRecord->user_id = $user->id;
                $depositRecord->amount = $amount;
                $depositRecord->payment_method = $gateWayName;
//                $depositRecord->transaction_id = $user->id;
                $depositRecord->response = json_encode($response);
                $depositRecord->status = 1;

                $depositRecord->save();
                Toastr::success(trans('frontend.Payment done successfully'), trans('common.Success'));
                DB::commit();

                Session::forget($pre_booking_session);
                return true;

            } else {

                 Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                return false;
            }


        } catch (\Exception $e) {

            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent(), true);
        }
    }

    public function paypalSuccess(Request $request)
    {

        // Once the transaction has been approved, we need to complete it.
        if ($request->input('paymentId') && $request->input('PayerID')) {
            $transaction = $this->payPalGateway->completePurchase(array(
                'payer_id' => $request->input('PayerID'),
                'transactionReference' => $request->input('paymentId'),
            ));
            $response = $transaction->send();

            if ($response->isSuccessful()) {
                // The customer has successfully paid.
                $arr_body = $response->getData();
                $paymentAmount = $arr_body['transactions'][0]['amount'];

                $amount = number_format($paymentAmount['total'], 2);

                $payWithPapal = $this->bookingWithGateWay($amount, $arr_body, "PayPal");
                if ($payWithPapal) {
                    Toastr::success(trans('frontend.Payment done successfully'), trans('common.Success'));
                    return redirect(route('studentDashboard'));
                } else {
                    Toastr::error(trans('frontend.Something Went Wrong'), trans('common.Error'));;
                    return redirect(route('studentDashboard'));
                }

            } else {
                $msg = str_replace("'", " ", $response->getMessage());
                Toastr::error($msg, trans('common.Failed'));
                return redirect()->back();
            }
        } else {
            Toastr::error(trans('frontend.Transaction is declined'));
            return redirect()->back();
        }


    }

    public function paypalFailed()
    {
        Toastr::error(trans('frontend.User is canceled the payment'), trans('common.Failed'));
        return redirect()->back();
    }
}
