@extends('backend.master')
@php
    $table_name='coupons';
@endphp
@section('table')
    {{$table_name}}
@stop
@section('mainContent')

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box ">

                <div class="row">
                    <div class="col-lg-12">
                        <div class="row justify-content-center">
                            <div class="col-12">
                                <div class="box_header common_table_header">
                                    <div class="main-title d-flex flex-wrap mb-0">
                                        <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px"> @if(!isset($edit))
                                                {{__('common.Add') }}
                                            @else
                                                {{__('common.Update')}}
                                            @endif {{__('survey.Survey')}}</h3>
                                        @if(isset($edit))

                                            <a href="{{route('survey.survey_add')}}"
                                               class="primary-btn   fix-gr-bg ms-3 "
                                               style=" "
                                               title="{{__('coupons.Add')}}">
                                                <i class="ti ti-plus"></i>
                                                {{__('common.Add')}} </a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        @if (isset($edit))

                            @if (permissionCheck('survey.survey_update'))
                                <form action="{{route('survey.survey_update')}}" method="POST" id="coupon-form"
                                      name="coupon-form" enctype="multipart/form-data">
                                    @endif
                                    <input type="hidden" name="id" value="{{$edit->id}}">

                                    @else

                                        @if (permissionCheck('survey.survey_store'))
                                            <form action="{{route('survey.survey_store') }}" method="POST"
                                                  id="coupon-form" name="coupon-form" enctype="multipart/form-data">
                                                @endif

                                                @endif

                                                @csrf

                                                <input type="hidden" name="assignment_from" value="1">
                                                <div class="row">

                                                    @php
                                                        if(isset($edit)){
                                                            if ($edit->privacy==1) {
                                                                $show_available_for='none';
                                                            } else {
                                                                 $show_available_for='block';
                                                            }

                                                        }else{
                                                             $show_available_for='block';
                                                        }
                                                    @endphp
                                                    <div class="col-xl-2">
                                                        <div class="primary_input mb-25 mt-15 d-flex">
                                                            <label
                                                                class="primary_input_label">{{__('assignment.Anonymous')}}
                                                                <strong
                                                                    class="text-danger">*</strong> [<span
                                                                    id="show_privacy">{{__('common.No')}}</span>]</label>
                                                            <label class="switch_toggle ml-20" for="privacy_set">
                                                                <input type="checkbox" class="status_enable_disable"
                                                                       name="is_anonymous" id="privacy_set"
                                                                       {{isset($edit)? $edit->is_anonymous==1? 'checked':'':''}}  value="1">
                                                                <i class="slider round"></i>
                                                            </label>

                                                        </div>
                                                    </div>
                                                    <div class="col-xl-10">
                                                        <div class="row">
                                                            <div class="col-md-{{isModuleActive('Org')?3:6}}">
                                                                <label class="primary_input_label"
                                                                       for=""> {{__('common.Category')}}
                                                                    <strong class="text-danger">*</strong>
                                                                </label>
                                                                <select class="primary_select "
                                                                        id="category_id" name="category_id">
                                                                    <option
                                                                        data-display="{{__('common.Select')}} {{__('common.Category')}}"
                                                                        value="">{{__('common.Select')}} {{__('common.Category')}}
                                                                    </option>

                                                                    @php
                                                                        if (isset($edit)){
                                                                      $category_id=   $edit->category_id;
                                                                    }else{
                                                                        $category_id =request('category_id');
                                                                    }
                                                                        request()->replace(['category'=>$category_id]);
                                                                    @endphp
                                                                    @foreach($categories as $category)
                                                                        @if($category->parent_id==0)
                                                                            @include('backend.categories._single_select_option',['category'=>$category,'level'=>1])
                                                                        @endif
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            <div class="col-md-{{isModuleActive('Org')?3:6}}">
                                                                <label class="primary_input_label"
                                                                       for="">  {{__('survey.Survey Type')}}
                                                                    <strong class="text-danger">*</strong>
                                                                </label>
                                                                @php
                                                                    if (isset($edit)){
                                                                      $survey_type=   $edit->survey_type;
                                                                    }else{
                                                                        $survey_type =request('survey_type');
                                                                    }
                                                                @endphp
                                                                <select
                                                                    {{ $errors->has('survey_type') ? ' autofocus' : '' }}
                                                                    class="primary_select{{ $errors->has('survey_type') ? ' is-invalid' : '' }}"
                                                                    name="survey_type" id="survey_type">
                                                                    <option
                                                                        value="1" {{$survey_type=='1'?'selected':''}}> {{__('survey.Course survey')}}</option>
                                                                    <option
                                                                        value="2" {{$survey_type=='2'?'selected':''}}> {{__('survey.Independence')}}</option>
                                                                </select>
                                                            </div>

                                                            @if(isModuleActive('OrgInstructorPolicy'))
                                                                @include('survey::partials.org_audience')
                                                                @include('survey::partials.position_audience')

                                                            @endif
                                                        </div>
                                                    </div>

                                                </div>


                                                <div class="row  mt-20"
                                                     id="student_section">

                                                    <div class="col-lg-6" id="course_list"
                                                         style="display:  {{isset($edit)? $edit->survey_type==1? 'block':'none':'block'}}">
                                                        <div class="primary_input mb-25">
                                                            <label class="primary_input_label"
                                                                   for="course">{{ __('courses.Course') }} <strong
                                                                    class="text-danger">*</strong></label>


                                                            <select name="courses[]" id="userInput"
                                                                    class="multypol_check_select active mb-15 e1"
                                                                    multiple>

                                                                @foreach ($courses as $course)
                                                                    <option
                                                                        value="{{@$course->id}}" {{isset($edit) ? $edit->course_id==$course->id? 'selected' : '' : ''}} >{{@$course->title}}</option>
                                                                @endforeach

                                                            </select>

                                                            @if ($errors->has('course'))
                                                                <span class="invalid-feedback d-block mb-10"
                                                                      role="alert">
                                                                <strong>{{ @$errors->first('course') }}</strong>
                                                            </span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        @if(isModuleActive('Org'))
                                                            <div class="primary_input mb-25">
                                                                <label class="primary_input_label"
                                                                       for="course">{{ __('org.Leaderboard point') }}</label>
                                                                <input class="primary_input_field"
                                                                       name="org_leaderboard_point"
                                                                       placeholder="{{__('org.Leaderboard point')}}"
                                                                       id=""
                                                                       min="0" step="any" type="number"
                                                                       value="{{old('org_leaderboard_point',isset($edit) ? $edit->org_leaderboard_point:0)}}" {{$errors->has('org_leaderboard_point') ? 'autofocus' : ''}}>
                                                            </div>

                                                        @endif
                                                    </div>
                                                </div>
                                                @php
                                                    if(isset($edit)){
                                                        if ($edit->survey_for==4) {
                                                            $show_user_section='';
                                                        } else {
                                                            $show_user_section='d-none';
                                                        }
                                                    }else{
                                                        $show_user_section='d-none';
                                                    }
                                                @endphp
                                                <div class="row   {{@$show_user_section}} mt-20" id="user_section">


                                                    <div class="col-xl-6">
                                                        <div class="primary_input mb-25">
                                                            <label class="primary_input_label"
                                                                   for="role">{{ __('role.Role') }} <strong
                                                                    class="text-danger">*</strong></label>

                                                            <select
                                                                class="primary_select mb-25 select_role  {{ @$errors->has('role') ? ' is-invalid' : '' }}"
                                                                name="role" id="SurveyStaffsByRole">
                                                                <option
                                                                    value="">{{__('common.Select')}} {{__('role.Role')}}</option>
                                                                @foreach ($roles as $role)
                                                                    <option
                                                                        value="{{@$role->id}}" {{isset($edit) ? $edit->role_id==$role->id? 'selected' : '' : ''}} >{{@$role->name}}</option>
                                                                @endforeach

                                                            </select>
                                                            @if ($errors->has('role'))
                                                                <span class="invalid-feedback d-block mb-10"
                                                                      role="alert">
                                                                <strong>{{ @$errors->first('role') }}</strong>
                                                            </span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-6" id="selectStaffsDiv">
                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <div class="primary_input mb-15">
                                                                    <label class="primary_input_label"
                                                                           for="userInput">@lang('common.Name')
                                                                        <span class="text-danger">*</span>
                                                                    </label>
                                                                    <select name="user_ids[]" id="userInput"
                                                                            class="multypol_check_select active mb-15 e1"
                                                                            multiple>
                                                                        @if (isset($edit))
                                                                            @foreach ($users as $user)
                                                                                <option selected
                                                                                        value="{{$user->id}}"> {{$user->name}}</option>
                                                                            @endforeach
                                                                        @endif
                                                                    </select>
                                                                    @if ($errors->has('user_ids'))
                                                                        <span class="invalid-feedback invalid-select"
                                                                              role="alert">
                                                                        <strong>{{ $errors->first('user_ids') }}</strong>
                                                                    </span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <input type="hidden" id="url" value="{{url('/')}}">


                                                <div class="row">

                                                    {{-- input title  --}}
                                                    <div class="col-lg-12" id="title_section">
                                                        <div class="primary_input mb-25">
                                                            <label class="primary_input_label"
                                                                   for="title">{{ __('common.Title') }} <strong
                                                                    class="text-danger">*</strong></label>
                                                            <input name="title" id="title"
                                                                   class="primary_input_field name {{ @$errors->has('title') ? ' is-invalid' : '' }}"
                                                                   placeholder="{{ __('common.Title') }}"
                                                                   type="text"
                                                                   value="{{isset($edit)?$edit->title:old('title')}}" {{$errors->has('title') ? 'autofocus' : ''}}>
                                                            @if ($errors->has('title'))
                                                                <span class="invalid-feedback d-block mb-10"
                                                                      role="alert">
                                                                    <strong>{{ @$errors->first('title') }}</strong>
                                                                </span>
                                                            @endif
                                                        </div>
                                                    </div>


                                                </div>
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <input onclick="setTimeForSurvey()" id="set_time_checkbox"
                                                               type="checkbox"
                                                               {{isset($edit)? $edit->set_time==1? 'checked':'':''}} class="common-checkbox name"
                                                               name="set_time" value="1">
                                                        <label for="set_time_checkbox">{{__('survey.Set Time')}}</label>
                                                    </div>
                                                </div>
                                                {{-- <div class="row" id="set_time_div" style="display: {{isset($edit) ? $edit->set_time==1 ? 'block':'none':'none'}}"> --}}
                                                <div id="set_time_div"
                                                     class="row {{isset($edit) ? $edit->set_time==1 ? 'd-flex':'d-none':'d-none'}}">
                                                    {{-- Start Date Input --}}
                                                    <div class="col-xl-6">
                                                        <input type="hidden" name="today" value="{{date('m/d/Y')}}">
                                                        <div class="primary_input mb-15">
                                                            <label class="primary_input_label"
                                                            >{{ __('common.Publish') }} {{__('common.Date')}}
                                                                <strong
                                                                    class="text-danger">*</strong> </label>
                                                            <div class="primary_datepicker_input">
                                                                <div class="g-0  input-right-icon">
                                                                    <div class="col">
                                                                        <div class="">
                                                                            <input
                                                                                placeholder="{{ __('common.Publish') }} {{__('common.Date')}}"
                                                                                class="primary_input_field primary-input date form-control  {{ @$errors->has('publish_date') ? ' is-invalid' : '' }}"
                                                                                type="text"
                                                                                name="publish_date"
                                                                                value="{{isset($edit)?getJsDateFormat($edit->publish_date) : getJsDateFormat(now()->format('m/d/Y'))}}"
                                                                                autocomplete="off" required>
                                                                        </div>
                                                                    </div>
                                                                    <button class="" type="button">
                                                                        <i class="ti-calendar"></i>
                                                                    </button>
                                                                </div>
                                                                @if ($errors->has('start_date'))
                                                                    <span class="invalid-feedback d-block mb-10"
                                                                          role="alert">
                                                                    <strong>{{ @$errors->first('start_date') }}</strong>
                                                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-6">
                                                        <div class="primary_input mb-15">
                                                            <label class="primary_input_label"
                                                                   for="start_time">{{ __('common.Publish') }} {{__('common.Time')}}
                                                                <strong
                                                                    class="text-danger">*</strong> </label>
                                                            <div class="primary_datepicker_input">
                                                                <div class="g-0  input-right-icon">
                                                                    <div class="col">
                                                                        <div class="">
                                                                            <input
                                                                                placeholder="{{ __('common.Publish') }} {{__('common.Time')}}"
                                                                                class="primary_input_field primary-input time form-control  {{ @$errors->has('publish_time') ? ' is-invalid' : '' }}"
                                                                                type="text"
                                                                                name="publish_time"
                                                                                value="{{isset($edit)?  date('h:i:sa', strtotime(@$edit->publish_time)) : date("h:i:sa")}}"
                                                                                autocomplete="off" required>
                                                                        </div>
                                                                    </div>
                                                                    <button class="" type="button">
                                                                        <i class="ti-time"></i>
                                                                    </button>
                                                                </div>
                                                                @if ($errors->has('start_time'))
                                                                    <span class="invalid-feedback d-block mb-10"
                                                                          role="alert">
                                                                    <strong>{{ @$errors->first('start_time') }}</strong>
                                                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row deadlineSet">
                                                    {{-- Start Date Input --}}
                                                    <div class="col-xl-6">
                                                        <div class="primary_input mb-15">
                                                            <label class="primary_input_label"
                                                            >{{ __('survey.Deadline') }} {{__('common.Date')}}
                                                                <strong
                                                                    class="text-danger">*</strong> </label>
                                                            <div class="primary_datepicker_input">
                                                                <div class="g-0  input-right-icon">
                                                                    <div class="col">
                                                                        <div class="">
                                                                            <input
                                                                                placeholder="{{ __('survey.Deadline') }} {{__('common.Date')}}"
                                                                                class="primary_input_field primary-input date form-control  {{ @$errors->has('deadline_date') ? ' is-invalid' : '' }}"
                                                                                type="text"
                                                                                name="deadline_date"
                                                                                value="{{isset($edit)?getJsDateFormat($edit->deadline_date) : getJsDateFormat(now()->addDay()->format('m/d/Y'))}}"
                                                                                autocomplete="off">
                                                                        </div>
                                                                    </div>
                                                                    <button class="" type="button">
                                                                        <i class="ti-calendar"></i>
                                                                    </button>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-6">
                                                        <div class="primary_input mb-15">
                                                            <label class="primary_input_label"
                                                                   for="start_time">{{ __('survey.Deadline') }} {{__('common.Time')}}
                                                                <strong
                                                                    class="text-danger">*</strong> </label>
                                                            <div class="primary_datepicker_input">
                                                                <div class="g-0  input-right-icon">
                                                                    <div class="col">
                                                                        <div class="">
                                                                            <input
                                                                                placeholder="{{ __('survey.Deadline') }} {{__('common.Time')}}"
                                                                                class="primary_input_field primary-input time form-control  {{ @$errors->has('deadline_time') ? ' is-invalid' : '' }}"
                                                                                type="text"
                                                                                name="deadline_time"
                                                                                value="{{isset($edit)?  date('h:i:sa', strtotime(@$edit->deadline_time)) : date("h:i:sa")}}"
                                                                                autocomplete="off">
                                                                        </div>
                                                                    </div>
                                                                    <button class="" type="button">
                                                                        <i class="ti-time"></i>
                                                                    </button>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="row">

                                                    {{-- End Date Input --}}
                                                    <div class="col-lg-12">
                                                        <div class="input-effect">
                                                            <label
                                                                class="primary_input_label"> {{__('homework.Description')}}
                                                            </label>
                                                            <textarea
                                                                class="textArea lms_summernote {{ @$errors->has('description') ? ' is-invalid' : '' }}"
                                                                cols="30" rows="10"
                                                                name="description">{{isset($edit)? $edit->description:(old('description')!=''?(old('description')):'')}}</textarea>

                                                            <span class="focus-border textarea"></span>
                                                            @if ($errors->has('description'))
                                                                <span
                                                                    class="error text-danger"><strong>{{ $errors->first('description') }}</strong></span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row">

                                                    <div class="col-lg-12 text-center">
                                                        <div class="d-flex justify-content-center pt_20">
                                                            <button type="submit"
                                                                    class="primary-btn semi_large fix-gr-bg"
                                                                    data-bs-toggle="tooltip" title=""
                                                                    id="save_button_parent">
                                                                <i class="ti-check"></i>
                                                                @if(!isset($edit))
                                                                    {{ __('common.Save') }}
                                                                @else
                                                                    {{ __('common.Update') }}
                                                                @endif
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <div id="edit_form">

    </div>
    <div id="view_details">

    </div>
    <input type="hidden" name="status_route" class="status_route" value="{{ route('coupons.status_update') }}">

    @include('backend.partials.delete_modal')
@endsection
@push('scripts')
    <script src="{{asset('public/backend/js/category.js')}}{{assetVersion()}}"></script>
    <script src="{{asset('Modules/Survey/Resources/assets/js/survey.js')}}{{assetVersion()}}"></script>

    <script>
        (function ($) {
            "use strict"
            $(document).on('change', '#survey_type', function () {
                let type = $(this).children("option:selected").val();
                if (type == 1) {
                    $('.deadlineSet').hide();
                    $('#course_list').css('display', 'block')
                } else {
                    $('.deadlineSet').show();
                    $('#course_list').css('display', 'none')
                }

            });

            $(document).ready(function () {
                $('#survey_type').trigger('change');
            });
        })(jQuery);

    </script>
@endpush
