<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductSkuTable extends Migration
{
    public function up()
    {
        Schema::create('product_sku', function (Blueprint $table) {
            $table->id();
            $table->string("sku", 250)->nullable();
            $table->unsignedBigInteger("product_id")->nullable();
             $table->double("price", 16,2)->default(0);
            $table->unsignedInteger('stock')->default(0);
            $table->string('image')->nullable();
             $table->timestamps();
        });
    }


    public function down()
    {
        Schema::dropIfExists('product_sku');
    }
}
