<?php

namespace Modules\RegistrationBonus\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Modules\RegistrationBonus\Entities\RegistrationBonusHistory;
use Yajra\DataTables\Facades\DataTables;

class RegistrationBonusHistoryController extends Controller
{
   public function index()
   {
     return view('registrationbonus::history');
   }


   public function  dataTable(Request $request)
   {

       $histories = RegistrationBonusHistory::with(['user']);


        if ($request->filled('bonus_for')) {
           $histories->where('bonus_for', $request->input('bonus_for'));
       }
        if ($request->filled('start_date') && $request->filled('end_date')) {
           try {
               $startDate = Carbon::parse($request->input('start_date'))->startOfDay();
               $endDate = Carbon::parse($request->input('end_date'))->endOfDay();
               $histories->whereBetween('created_at', [$startDate, $endDate]);
           } catch (\Exception $e) {
            }
       }
        return Datatables::of($histories)
            ->addIndexColumn()

           ->addColumn('user_name', function ($history) {
               return optional($history->user)->name ?: '';

            })->addColumn('role_name', function ($history) {
               return optional($history->user->role)->name ?: '';

            })
            ->editColumn('bonus_for', function ($history) {
                return ucwords(str_replace('_',' ',$history->bonus_for));

            })
           ->editColumn('amount',function($history){
                return showPrice($history->amount);
            })
           ->editColumn('created_at',function($history){
                return showDate($history->created_at);
            })
            ->make(true);

   }
}
