@extends('backend.master')
@php
    $table_name='coupons';
@endphp
@section('table')
    {{$table_name}}
@stop
@section('mainContent')

    {{generateBreadcrumb()}}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">
                    <div class="white-box ">

                        <div class="row justify-content-center">
                            <div class="col-12">
                                <div class="box_header common_table_header">
                                    <div class="main-title d-flex flex-wrap mb-0">
                                        <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px"> @if(!isset($edit))
                                                {{__('common.Add') }}
                                            @else
                                                {{__('common.Update')}}
                                            @endif {{__('assignment.Assignment')}}</h3>
                                        @if(isset($edit))

                                            <a href="{{route('assignment_add')}}"
                                               class="primary-btn small fix-gr-bg ms-3 "
                                                title="{{__('coupons.Add')}}">+ </a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        <form
                            @if (isset($edit))
                                action="{{route('assignment_update')}}" method="POST" id="coupon-form"
                            name="coupon-form" enctype="multipart/form-data">
                            <input type="hidden" name="id" value="{{$edit->id}}">
                            @else
                                action="{{route('assignment_store') }}" method="POST" id="coupon-form"
                                name="coupon-form" enctype="multipart/form-data">
                            @endif

                            @csrf

                            <input type="hidden" name="assignment_from" value="1">
                            <div class="row">

                                 <div class="col-xl-6">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label"
                                               for="title">{{ __('common.Title') }} <strong
                                                class="text-danger">*</strong></label>
                                        <input name="title" id="title"
                                               class="primary_input_field name {{ @$errors->has('title') ? ' is-invalid' : '' }}"
                                               placeholder="{{ __('common.Title') }}"
                                               type="text"
                                               value="{{isset($edit)?$edit->title:old('title')}}" {{$errors->has('title') ? 'autofocus' : ''}}>
                                        @if ($errors->has('title'))
                                            <span class="invalid-feedback d-block mb-10" role="alert">
                                                                <strong>{{ @$errors->first('title') }}</strong>
                                                            </span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label"
                                               for="course">{{ __('courses.Course') }}</label>

                                        <select
                                            class="primary_select mb-25  {{ @$errors->has('course') ? ' is-invalid' : '' }}"
                                            name="course" id="course">
                                            <option
                                                value="">{{__('assignment.Select Related Course')}}</option>
                                            @foreach ($courses as $course)
                                                <option
                                                    value="{{@$course->id}}" {{isset($edit) ? $edit->course_id==$course->id? 'selected' : '' : ''}} >{{@$course->title}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">

                                {{-- input marks  --}}
                                <div class="col-xl-6">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label"
                                               for="number">{{ __('assignment.Marks') }}<strong
                                                class="text-danger">*</strong> </label>
                                        <input name="marks"
                                               class="primary_input_field name {{ @$errors->has('marks') ? ' is-invalid' : '' }}"
                                               placeholder="{{ __('assignment.Marks') }}"
                                               type="text" id="number" min="0" step="any"
                                               {{$errors->has('marks') ? 'autofocus' : ''}}
                                               value="{{isset($edit)?$edit->marks:old('marks')}}">
                                        @if ($errors->has('marks'))
                                            <span class="invalid-feedback d-block mb-10" role="alert">
                                                            <strong>{{ @$errors->first('marks') }}</strong>
                                                        </span>
                                        @endif
                                    </div>
                                </div>

                                {{-- input Amount  --}}
                                <div class="col-xl-6">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label"
                                               for="number2">{{ __('assignment.Min Percentage') }}
                                            <strong
                                                class="text-danger">*</strong></label>
                                        <input name="min_parcentage"
                                               {{$errors->has('min_parcentage') ? 'autofocus' : ''}}
                                               class="primary_input_field name {{ @$errors->has('code') ? ' is-invalid' : '' }}"
                                               placeholder="{{ __('assignment.Min Percentage') }}"
                                               type="number" id="number2" min="0" step="any"
                                               value="{{isset($edit)?$edit->min_parcentage:old('min_parcentage')}}">
                                        @if ($errors->has('min_parcentage'))
                                            <span class="invalid-feedback d-block mb-10" role="alert">
                                                            <strong>{{ @$errors->first('min_parcentage') }}</strong>
                                                        </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="row">

                                 <div class="col-xl-6">
                                    <div class=" mb-35">


                                        <x-upload-file
                                            name="attachment"
                                            media_id="{{isset($edit)?$edit->attachment_media?->media_id:''}}"
                                            label="{{ __('assignment.Attachment') }}"/>
                                    </div>
                                </div>
                                {{-- Start Date Input --}}
                                <div class="col-xl-6">
                                    <div class="primary_input mb-15">
                                        <label class="primary_input_label"
                                               for="start_date">{{ __('assignment.Submit Date') }} <span
                                                class="required_mark">*</span></label>
                                        <div class="primary_datepicker_input">
                                            <div class="g-0  input-right-icon">
                                                <div class="col">
                                                    <div class="">
                                                        <input
                                                            placeholder="{{ __('assignment.Submit Date') }}"
                                                            class="primary_input_field primary-input date form-control  {{ @$errors->has('last_date_submission') ? ' is-invalid' : '' }}"
                                                            id="start_date" type="text"
                                                            name="last_date_submission"
                                                            value="{{isset($edit)?  date('m/d/Y', strtotime(@$edit->last_date_submission)) : date('m/d/Y')}}"
                                                            autocomplete="off" required>
                                                    </div>
                                                </div>
                                                <button class="" type="button">
                                                    <i class="ti-calendar"></i>
                                                </button>
                                            </div>
                                            @if ($errors->has('start_date'))
                                                <span class="invalid-feedback d-block mb-10"
                                                      role="alert">
                                                <strong>{{ @$errors->first('start_date') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">

                                {{-- End Date Input --}}
                                <div class="col-lg-12">
                                    <div class="input-effect">
                                        <label class="primary_input_label"> {{__('assignment.Description')}}
                                            <span class="required_mark">*</span>
                                        </label>
                                        <textarea
                                            class="textArea lms_summernote {{ @$errors->has('description') ? ' is-invalid' : '' }}"
                                            cols="30" rows="10"
                                            name="description">{{isset($edit)? $edit->description:(old('description')!=''?(old('description')):'')}}</textarea>

                                        <span class="focus-border textarea"></span>
                                        @if ($errors->has('description'))
                                            <span
                                                class="error text-danger"><strong>{{ $errors->first('description') }}</strong></span>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="row">

                                <div class="col-lg-12 text-center">
                                    <div class="d-flex justify-content-center pt_20">
                                        <button type="submit" class="primary-btn semi_large fix-gr-bg"
                                                data-bs-toggle="tooltip" title=""
                                                id="save_button_parent">
                                            <i class="ti-check"></i>
                                            @if(!isset($edit))
                                                {{ __('common.Save') }}
                                            @else
                                                {{ __('common.Update') }}
                                            @endif
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <div id="edit_form">

    </div>
    <div id="view_details">

    </div>
    <input type="hidden" name="status_route" class="status_route" value="{{ route('coupons.status_update') }}">

    @include('backend.partials.delete_modal')
@endsection
@push('scripts')
    <script src="{{asset('public/backend/js/category.js')}}"></script>
@endpush
