@php
    $table_name = 'appointment_frontend_pages';
@endphp
@section('table')
    {{ $table_name }}
@endsection
<table id="lms_table" class="table Crm_table_active3">
    <thead>
    <tr>
        <th>{{ __('common.SL') }}</th>
        <th>{{ __('common.Section') }}</th>
        <th>{{ __('common.Status') }}</th>
        <th>{{ __('common.Action') }}</th>

    </tr>
    </thead>
    <tbody>
    @php
        $notActions = ['teaching-category', 'partner'];
    @endphp
    @foreach ($pages as $row)
        <tr>
            <td>{{ $loop->iteration }}</td>
            <td>{{ $row->title }}</td>
            <td>

                <label class="switch_toggle">
                    <input type="checkbox" class="status_enable_disable"
                           {{ $row->status ? 'checked' : '' }} value="{{ $row->id }}">
                    <i class="slider round"></i>
                </label>
            </td>
            <td>
                <div class="dropdown CRM_dropdown">
                    <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenu2"
                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        {{ __('common.select') }}
                    </button>
                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu2">
                        @if (!in_array($row->name, $notActions))
                            @if (permissionCheck('appointment.page.design.update'))
                                <a href="{{ route('appointment.page.design', $row->id) }}"
                                   class="dropdown-item">{{ __('appointment.Design') }}</a>
                            @endif
                            @if (permissionCheck('appointment.page.show'))
                                <a href="{{ route('appointment.page.show', $row->id) }}"
                                   class="dropdown-item">{{ __('common.view') }}</a>
                            @endif
                            @if (permissionCheck('appointment.page.update'))
                                <a class="dropdown-item edit_row" data-bs-toggle="modal"
                                   data-bs-target="#updatePage_{{ $row->id }}">{{ __('common.edit') }}</a>
                            @endif
                        @endif

                    </div>
                </div>
            </td>
        </tr>

        <div class="modal fade admin-query" id="updatePage_{{ $row->id }}">
            <div class="modal-dialog  modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">{{ __('common.Update') }}</h4>
                        <button type="button" class="close " data-bs-dismiss="modal">
                            <i class="ti-close "></i>
                        </button>
                    </div>

                    <div class="modal-body">

                        <form action="{{ route('appointment.page.update', $row->id) }}" method="POST" enctype="multipart/form-data" class="form-horizontal">
                            @method('PUT')
                            @csrf

                        <div class="row">
                            <div class="col-xl-12">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">{{ __('common.Section') }} <strong
                                            class="text-danger">*</strong></label>
                                    <input class="primary_input_field" name="title" placeholder="-" id="addName"
                                           type="text" value="{{ $row->title }}">
                                </div>
                            </div>

                        </div>
                        <div class="col-lg-12 text-center pt_15">
                            <div class="d-flex justify-content-center">
                                <button class="primary-btn semi_large2  fix-gr-bg" type="submit"><i
                                        class="ti-check"></i> {{ __('common.Save') }}
                                </button>
                            </div>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
    </tbody>
</table>
