<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\FrontendManage\Entities\FrontPage;
use Modules\FrontendManage\Entities\HeaderMenu;

class AddAppointmentPageToFrontendPage extends Migration
{
    public function up()
    {
        $check_forum = FrontPage::where('slug', '/appointment')->first();
        if (!$check_forum) {
            $check_forum = new FrontPage();
            $check_forum->name ='Appointment';
            $check_forum->title ='Appointment';
            $check_forum->sub_title ='Appointment';
            $check_forum->details ='Appointment Page';
            $check_forum->slug ='/appointment';
            $check_forum->status =1;
            $check_forum->is_static =1;
            $check_forum->save();
        }

        $forum = FrontPage::where('slug', '/appointment')->first();
        $header_menu = HeaderMenu::where('link', '/appointment')->first();
        if ($forum && $header_menu == null) {
            $header_menu = new HeaderMenu();
            $header_menu->type = "Static Page";
            $header_menu->element_id = $forum->id;
            $header_menu->title = $forum->title;
            $header_menu->link = $forum->slug;
            $header_menu->position = 8;
            $header_menu->save();

        }
        // tutor finder

        $check_forum = FrontPage::where('slug', '/appointment/tutor-finder')->first();
        if (!$check_forum) {
            $check_forum = new FrontPage();
            $check_forum->name ='Tutor Finder';
            $check_forum->title ='Tutor Finder';
            $check_forum->sub_title ='Tutor Finder';
            $check_forum->details ='Tutor Finder Page';
            $check_forum->slug ='/appointment/tutor-finder';
            $check_forum->status =1;
            $check_forum->is_static =1;
            $check_forum->save();

        }

        $forum = FrontPage::where('slug', '/appointment/tutor-finder')->first();
        $header_menu2 = HeaderMenu::where('link', '/appointment/tutor-finder')->first();
        if ($forum && $header_menu2 == null) {
            $menu = new HeaderMenu();
            $menu->type = "Static Page";
            $menu->parent_id = $header_menu->id;
            $menu->element_id = $forum->id;
            $menu->title = $forum->title;
            $menu->link = $forum->slug;
            $menu->position = 9;
            $menu->save();

        }
    }

    public function down()
    {
        //
    }
}
