<div class="row">
    <div class="col-xl-4">
        <label class="primary_input_label"
               for="category"><?php echo e(__('courses.Category')); ?></label>
        <select class="primary_select teachingCategory" data-serial_id="0" name="teachingCategory[0][category]"
                id="teachingCategory"
            <?php echo e($errors->has('category') ? 'autofocus' : ''); ?>>
            <option data-display="<?php echo e(__('common.Select')); ?> <?php echo e(__('quiz.Category')); ?> "
                    value=""><?php echo e(__('common.Select')); ?> <?php echo e(__('quiz.Category')); ?> </option>
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($category->id); ?>"><?php echo e(@$category->name); ?> </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div class="col-xl-4 courseBox mt-30 teachingSubCategoryDiv" id="teachingSubCategoryDiv_0">
        <select class="primary_select teachingSubCategory" name="teachingCategory[0][sub_category]"
                id="teachingSubCategory_0"
            <?php echo e($errors->has('sub_category') ? 'autofocus' : ''); ?>>
            <option
                data-display="<?php echo e(__('common.Select')); ?> <?php echo e(__('courses.Sub Category')); ?>  "
                value=""><?php echo e(__('common.Select')); ?> <?php echo e(__('courses.Sub Category')); ?>

            </option>
        </select>
    </div>

    <div class="col-xl-3">
        <label class="primary_input_label"
               for="category"><?php echo e(__('courses.Level')); ?></label>
        <select class="primary_select" name="teachingCategory[0][level]" id="category">
            <option data-display="<?php echo e(__('appointment.Select Level')); ?>" value="">
                <?php echo e(__('appointment.Select Level')); ?></option>
            <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($level->id); ?>"><?php echo e(@$level->title); ?> </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <div class="col-xl-1 mt-33">
        <button class="removeTeachingCategoryBtn primary-btn icon-only fix-gr-bg fl-r"
                type="button">
            <span class="ti-trash"></span></button>
    </div>
</div>
<?php $__env->startPush('scripts'); ?>
    <script>
        (function ($) {
            "use strict";

            $(document).on('change', '.teachingCategory', function () {
                let url = $("#url").val();
                let category_id = $(this).val();
                var lang = window._locale;
                let serial_id = $(this).data('serial_id');
                var formData = {
                    id: $(this).val(),
                };
                console.log(formData);
                // get section for student
                $.ajax({
                    type: "GET",
                    data: formData,
                    dataType: "json",
                    url: url + "/" + "admin/course/ajaxGetCourseSubCategory",
                    success: function (data) {
                        // console.log(data);
                        var a = "";
                        $.each(data, function (i, item) {
                            if (item.length) {
                                $("#teachingSubCategory_" + serial_id).find("option").not(":first").remove();
                                $("#teachingSubCategoryDiv_" + serial_id + " ul").find("li").not(":first").remove();

                                $.each(item, function (i, subCategory) {
                                    $("#teachingSubCategory_" + serial_id).append(
                                        $("<option>", {
                                            value: subCategory.id,
                                            text: subCategory.name[lang],
                                        })
                                    );

                                    $("#teachingSubCategoryDiv_" + serial_id + " ul").append(
                                        "<li data-value='" +
                                        subCategory.id +
                                        "' class='option'>" +
                                        subCategory.name[lang] +
                                        "</li>"
                                    );
                                });
                            } else {
                                $("#teachingSubCategoryDiv_" + serial_id + " .current").html("Select Sub Category");
                                $("#teachingSubCategory_" + serial_id).find("option").not(":first").remove();
                                $("#teachingSubCategoryDiv_" + serial_id + " ul").find("li").not(":first").remove();
                            }
                        });
                        // console.log(a);
                    },
                    error: function (data) {
                        console.log("Error:", data);
                    },
                });
            });
        })(jQuery);
    </script>

<?php $__env->stopPush(); ?>
<?php /**PATH /home/minialms/card.minialms.com/Modules/Appointment/Resources/views/instructor/inc/create_teachingCategory.blade.php ENDPATH**/ ?>