<?php use Illuminate\Support\Carbon; ?>

<?php $__env->startSection('mainContent'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('Modules/ModuleManager/Resources/assets/sass/manage_module.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/vendor/spondonit/css/parsley.css')); ?>">

    <style>
        .check_box_table .QA_table .table tbody td:nth-child(2) {
            width: 250px !important;
        }

        .module_switch, .verifyBtn {
            color: #007bff !important;
        }

        .dataTables_filter > label {
            position: unset !important;
            opacity: 1;
            visibility: visible;
        }

        .allow-overflow {
            overflow: inherit;
        }

        .developer_link {
            font-weight: 400 !important;
            color: var(--backend-primary-color) !important;
        }

        .developer_link:hover {
            text-decoration: underline;
        }

        .up_st_admin_visitor .dataTables_filter > label {
            position: absolute !important;
            top: -7px;
            right: 0;
        }

        @media (max-width: 767px) {
            .up_st_admin_visitor .dataTables_filter > label {
                position: relative !important;
            }
        }

    </style>
    <?php echo generateBreadcrumb(); ?>

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row">
                    <div class="col-lg-12 pb-20">
                        <div class="main-title row-gap-10 d-flex justify-content-between align-items-md-center flex-column flex-md-row">
                            <h3 class="mb-0">
                                <span id="page_title"><?php echo e(__('setting.Module')); ?> <?php echo e(__('setting.Manage')); ?></span>

                            </h3>

                            <?php if(!config('app.demo_mode')): ?>
                                <a data-bs-toggle="modal"
                                   data-bs-target="#add_module" href="#"
                                   class="primary-btn fix-gr-bg small w-fit">  <span class="ti-plus pe-2"></span> <?php echo e(__('common.Add')); ?>

                                    / <?php echo e(__('common.Update')); ?> <?php echo e(__('setting.Module')); ?></a>
                            <?php endif; ?>
                        </div>

                    </div>

                    <div class="col-lg-12">


                        <div class="row">
                            <div class="col-lg-12 table-responsive allow-overflow">
                                <input type="hidden" name="url" id="url" value="<?php echo e(URL::to('/')); ?>">
                                <div class="  QA_section QA_section_heading_custom check_box_table">
                                    <div class="QA_table ">
                                        <table id="lms_table" class="table table-data">
                                            <thead>
                                            <tr>
                                                <th><?php echo e(__('setting.SL')); ?></th>
                                                <th><?php echo e(__('setting.Module')); ?><?php echo e(__('setting.Name')); ?></th>
                                                <th><?php echo e(__('setting.Description')); ?></th>
                                                <th class="text-start"><?php echo e(__('common.Action')); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>

                                            <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <?php
                                                    $is_module_available = base_path().'/'.'Modules/' . $module->name. '/Providers/' .$module->name. 'ServiceProvider.php';
                                                    $configFile = 'Modules/' . $module->name. '/' .$module->name. '.json';

                                                try {
                                                    $config =file_get_contents(base_path().'/'.$configFile);

                                                }catch (\Exception $exception){
                                                    $config =null;
                                                }


                                                ?>
                                                <tr>
                                                    <td><?php echo e(translatedNumber(++$key)); ?></td>
                                                    <td>
                                                        <?php if($module->name=='LmsSaas'): ?>
                                                            LMS-SAAS
                                                        <?php else: ?>
                                                            <?php echo e(@$module->name); ?>

                                                        <?php endif; ?>

                                                        <?php if(!empty($module->verify->purchase_code)): ?> <p
                                                            class="text-success">
                                                            <?php echo e(__('setting.Verified')); ?>

                                                            <?php echo e(trans('common.On')); ?>

                                                            <?php if($module->verify->activated_date): ?>
                                                                <?php echo e(translatedNumber(\Illuminate\Support\Carbon::parse($module->verify->activated_date)->translatedFormat('F jS, Y'))); ?>

                                                            <?php else: ?>
                                                                <?php echo e(translatedNumber(Carbon::now()->translatedFormat('F jS, Y'))); ?>

                                                            <?php endif; ?>
                                                        </p>
                                                        <?php if(!config('app.demo_mode')): ?>
                                                            <a href="#" class="module_switch"
                                                               data-id="<?php echo e(@$module->name); ?>"
                                                               id="module_switch_label<?php echo e(@$module->name); ?>"
                                                               data-item="<?php echo e($module); ?>">
                                                                <?php echo e(isModuleActive($module->name )  == false? trans('common.Activate'):trans('common.Deactivate')); ?>



                                                            </a>

                                                            <?php if ($__env->exists('service::license.revoke-module', ['name' =>$module->name, 'row' => true, 'file' =>false])) echo $__env->make('service::license.revoke-module', ['name' =>$module->name, 'row' => true, 'file' =>false], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                                        <?php endif; ?>
                                                        <div id="waiting_loader"
                                                             class="waiting_loader<?php echo e(@$module->name); ?>">
                                                            <img
                                                                src="<?php echo e(asset('public/backend/img/demo_wait.gif')); ?>"
                                                                width="20" height="20"/><br>

                                                        </div>

                                                        <?php else: ?><p class="text-danger">
                                                            <?php if(! file_exists($is_module_available)): ?>
                                                            <?php else: ?>

                                                                <a class=" verifyBtn"
                                                                   data-bs-toggle="modal" data-id="<?php echo e(@$module->name); ?>"
                                                                   data-bs-target="#Verify"
                                                                   href="#">   <?php echo e(__('setting.Verify')); ?></a>
                                                            <?php endif; ?>
                                                            <?php endif; ?>
                                                        </p>
                                                    </td>
                                                    <td>
                                                        <?php if(isset($config)): ?>
                                                            <?php

                                                                $name=$module->name;
                                                                $config= json_decode($config);
                                                                if (isset($config->$name->notes[0])){
                                                                echo $config->$name->notes[0];
                                                                echo '<br>';
                                                                echo 'Version: '.$config->$name->versions[0].' | Developed By <a class="  developer_link" href="https://www.aorasoft.com/">AoraSoft</a>';

                                                                }
                                                            ?>
                                                        <?php else: ?>
                                                            <?php
                                                                if (isset($module->details)){
                                                                    echo $module->details;
                                                                }
                                                            ?>
                                                        <?php endif; ?>
                                                    </td>

                                                    <td class="text-start">
                                                        <?php if(! file_exists($is_module_available)): ?>
                                                            <div class="row">
                                                                <div class="col-lg-12 ">
                                                                    <a class="primary-btn fix-gr-bg text-nowrap text-white"
                                                                       href="https://www.aorasoft.com/">   <?php echo e(__('common.Buy Now')); ?></a>

                                                                </div>
                                                            </div>
                                                        <?php endif; ?>
                                                        <?php if(file_exists($is_module_available)): ?>
                                                            <?php
                                                                $is_moduleV= $module->verify;
                                                                $configName = $module->name;
                                                                $availableConfig=Settings($configName);


                                                            ?>

                                                            <?php if(@$availableConfig==0 || @@$is_moduleV->purchase_code== null): ?>
                                                                <input type="hidden" name="name"
                                                                       value="<?php echo e(@$configName); ?>">

                                                            <?php else: ?>
                                                                <div class="row">
                                                                    <div class="col-lg-12 ">
                                                                        <?php if('RolePermission' != $module->name && 'TemplateSettings' != $module->name ): ?>
                                                                            <div id="waiting_loader"
                                                                                 class="waiting_loader<?php echo e(@$module->name); ?>">


                                                                            </div>
                                                                        <?php endif; ?>

                                                                    </div>
                                                            <?php endif; ?>
                                                        <?php endif; ?>

                                                    </td>


                                                </tr>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php if(!config('app.demo_mode')): ?>
        <div class="modal fade admin-query" id="add_module">
            <div class="modal-dialog  modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title"><?php echo e(__('setting.Add New/Update Module')); ?></h4>
                        <button type="button" class="close " data-bs-dismiss="modal">
                            <i class="ti-close "></i>
                        </button>
                    </div>

                    <div class="modal-body">
                        <form action="<?php echo e(route('modulemanager.uploadModule')); ?>" method="POST"
                              enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">

                                <div class="col-xl-12">
                                    <div class="primary_input mb-35">

                                        <div class="primary_file_uploader">
                                            <input class="primary-input filePlaceholder" type="text"
                                                   id=""
                                                   placeholder="<?php echo e(__('setting.Select Module ZIP File')); ?>"
                                                   readonly="">
                                            <button class="" type="button">
                                                <label class="primary-btn small fix-gr-bg"
                                                       for="document_file"><?php echo e(__('common.Browse')); ?></label>
                                                <input type="file" class="d-none fileUpload" name="module"
                                                       id="document_file">
                                            </button>
                                        </div>
                                    </div>
                                </div>


                            </div>

                            <div class="col-lg-12 text-center pt_15">
                                <div class="d-flex justify-content-center">
                                    <button class="primary-btn semi_large2  fix-gr-bg" id="save_button_parent"
                                            type="submit"><i
                                            class="ti-check"></i> <?php echo e(__('common.Save')); ?>

                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="modal fade admin-query" id="Verify">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Module Verification</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal">&times;
                    </button>
                </div>

                <div class="modal-body">
                    <form method="POST" action="<?php echo e(route('ManageAddOnsValidation')); ?>" class="form-horizontal"
                          enctype="multipart/form-data" id="content_form">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="name" value="" id="moduleName">
                        <input type="hidden" name="row" value="1">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for="user">Envato Email Address :</label>
                            <input type="text" class="form-control " name="envatouser"
                                   required="required"
                                   placeholder="Enter Your Envato Email Address"
                                   value="<?php echo e(old('envatouser')); ?>">
                        </div>
                        <div class="form-group">
                            <label for="purchasecode">Envato Purchase Code:</label>
                            <input type="text" class="form-control" name="purchase_code"
                                   required="required"
                                   placeholder="Enter Your Envato Purchase Code"
                                   value="<?php echo e(old('purchasecode')); ?>">
                        </div>
                        <div class="form-group">
                            <label for="domain">Installation Path:</label>
                            <input type="text" class="form-control"
                                   name="installationdomain" required="required"
                                   placeholder="Enter Your Installation Domain"
                                   value="<?php echo e(url('/')); ?>" readonly>
                        </div>
                        <div class="row mt-40">
                            <div class="col-lg-12 text-center">
                                <button class="primary-btn fix-gr-bg submit">
                                    <span class="ti-check me-2"></span> <?php echo e(__('setting.Verify')); ?>

                                </button>
                                <button type="button" class="primary-btn fix-gr-bg submitting" style="display: none">
                                    <i class="fas fa-spinner fa-pulse"></i>
                                    Verifying
                                </button>
                            </div>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('public/backend/js/module.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('public/vendor/spondonit/js/parsley.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('public/vendor/spondonit/js/function.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('public/vendor/spondonit/js/common.js')); ?>"></script>
    <script type="text/javascript">
        _formValidation('content_form');
    </script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script type="application/javascript">


        dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2]);

        let table = $('#lms_table').DataTable(dataTableOptions);


    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/ModuleManager/Resources/views/manage_module.blade.php ENDPATH**/ ?>