@extends('backend.master')
@section('mainContent')
    {{generateBreadcrumb()}}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="white_box_30px">
                                    <div class="main-title mb-25">
                                        <h3 class="mb-0">{{ __('whatsapp.view_settings') }}</h3>
                                    </div>

                                    <form action="{{ route('whatsapp-support.settings.update') }}" method="post">
                                        @csrf
                                        <div class="row" id="pusher">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{ __('whatsapp.color') }}</label>
                                                    <input class="primary_input_field" type="color" name="color"
                                                           value="{{ app('whatsapp_support_settings')->color ?? '' }}">
                                                </div>
                                            </div>

                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{ __('whatsapp.intro_text') }}</label>
                                                    <input class="primary_input_field" name="intro_text" type="text"
                                                           value="{{ app('whatsapp_support_settings')->intro_text ?? '' }}">
                                                </div>
                                            </div>

                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{ __('whatsapp.welcome_message') }}</label>
                                                    <input class="primary_input_field" name="welcome_message"
                                                           type="text"
                                                           value="{{ app('whatsapp_support_settings')->welcome_message ?? '' }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 d-flex justify-content-center align-content-center">

                                            <button class="primary-btn fix-gr-bg  " type="submit"><i
                                                    class="ti-check"></i>{{ __('whatsapp.update') }}
                                            </button>
                                        </div>
                                    </form>

                                </div>
                            </div>

                            <div class="col-lg-12 mt-4">
                                <div class="white_box_30px">
                                    <div class="main-title mb-25">
                                        <h3 class="mb-3">{{ __('whatsapp.functional_settings') }}</h3>
                                    </div>

                                    <form action="{{ route('whatsapp-support.settings.update') }}" method="post"
                                          enctype="multipart/form-data">
                                        @csrf
                                        <div class="row" id="pusher">
                                            <div class="col-xl-6 mb-4">
                                                <p class="primary_input_label">{{ __('whatsapp.agent_type') }}</p>
                                                <div class="d-flex radio-btn-flex">
                                                    <div class="me-3">
                                                        <input type="radio" name="agent_type"
                                                               {{ app('whatsapp_support_settings')->agent_type == 'multi' ? 'checked' : '' }} id="relationFather3"
                                                               value="multi" class="common-radio relationButton">
                                                        <label
                                                            for="relationFather3">{{ __('whatsapp.multi_agent') }}</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="agent_type"
                                                               {{ app('whatsapp_support_settings')->agent_type == 'single' ? 'checked' : '' }} id="relationMother4"
                                                               value="single" class="common-radio relationButton">
                                                        <label
                                                            for="relationMother4">{{ __('whatsapp.single_agent') }}</label>
                                                    </div>
                                                    @error('agent_type') <small
                                                        class="text-danger font-italic">*{{ $message }}</small> @enderror
                                                </div>
                                            </div>

                                            <div class="col-xl-6 mb-4">
                                                <p class="primary_input_label">{{ __('whatsapp.availability') }}</p>
                                                <div class="d-flex radio-btn-flex">
                                                    <div class="me-3">
                                                        <input type="radio" name="availability"
                                                               {{ app('whatsapp_support_settings')->availability == 'mobile' ? 'checked' : '' }} id="relationFather33333"
                                                               value="mobile" class="common-radio relationButton"
                                                               checked>
                                                        <label
                                                            for="relationFather33333">{{ __('whatsapp.only_mobile') }}</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="availability"
                                                               {{ app('whatsapp_support_settings')->availability == 'desktop' ? 'checked' : '' }} id="relationMother4433"
                                                               value="desktop" class="common-radio relationButton">
                                                        <label
                                                            for="relationMother4433">{{ __('whatsapp.only_desktop') }}</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="availability"
                                                               {{ app('whatsapp_support_settings')->availability == 'both' ? 'checked' : '' }} id="relationMother4222"
                                                               value="both" class="common-radio relationButton">
                                                        <label
                                                            for="relationMother4222">{{ __('whatsapp.both') }}</label>
                                                    </div>
                                                    @error('availability') <small
                                                        class="text-danger font-italic">*{{ $message }}</small> @enderror
                                                </div>
                                            </div>

                                            <div class="col-xl-6 mt-4">
                                                <p class="primary_input_label">{{ __('whatsapp.showing_page') }}</p>
                                                <div class="d-flex radio-btn-flex">
                                                    <div class="me-3">
                                                        <input type="radio" name="showing_page"
                                                               {{ app('whatsapp_support_settings')->showing_page == 'homepage' ? 'checked' : '' }} id="relationFather311"
                                                               value="homepage" class="common-radio relationButton"
                                                               checked>
                                                        <label
                                                            for="relationFather311">{{ __('whatsapp.only_homepage') }}</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="showing_page"
                                                               {{ app('whatsapp_support_settings')->showing_page == 'all' ? 'checked' : '' }} id="relationMother411"
                                                               value="all" class="common-radio relationButton">
                                                        <label
                                                            for="relationMother411">{{ __('whatsapp.all_page') }}</label>
                                                    </div>
                                                    @error('showing_page') <small
                                                        class="text-danger font-italic">*{{ $message }}</small> @enderror
                                                </div>
                                            </div>

                                            <div class="col-xl-6 mt-4">
                                                <p class="primary_input_label">{{ __('whatsapp.popup_open_initially') }}</p>
                                                <div class="d-flex radio-btn-flex">
                                                    <div class="me-3">
                                                        <input type="radio" name="open_popup"
                                                               {{ app('whatsapp_support_settings')->open_popup == 1 ? 'checked' : '' }} id="relationFather3119"
                                                               value="1" class="common-radio relationButton" checked>
                                                        <label
                                                            for="relationFather3119">{{ __('whatsapp.yes') }}</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="open_popup"
                                                               {{ app('whatsapp_support_settings')->open_popup == 0 ? 'checked' : '' }} id="relationMother4119"
                                                               value="0" class="common-radio relationButton">
                                                        <label
                                                            for="relationMother4119">{{ __('whatsapp.no') }}</label>
                                                    </div>
                                                    @error('open_popup') <small
                                                        class="text-danger font-italic">*{{ $message }}</small> @enderror
                                                </div>
                                            </div>
                                            <div class="col-xl-6 mt-4">
                                                <p class="primary_input_label">{{ __('whatsapp.show_unavailable_agent_in_popup') }}</p>
                                                <div class="d-flex radio-btn-flex">
                                                    <div class="me-3">
                                                        <input type="radio" name="show_unavailable_agent"
                                                               {{ app('whatsapp_support_settings')->show_unavailable_agent == 1 ? 'checked' : '' }} id="relationFather33333v"
                                                               value="1" class="common-radio relationButton" checked>
                                                        <label
                                                            for="relationFather33333v">{{ __('whatsapp.yes') }}</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="show_unavailable_agent"
                                                               {{ app('whatsapp_support_settings')->show_unavailable_agent == 0 ? 'checked' : '' }} id="relationMother4433v"
                                                               value="0" class="common-radio relationButton">
                                                        <label
                                                            for="relationMother4433v">{{ __('whatsapp.no') }}</label>
                                                    </div>
                                                    @error('show_unavailable_agent') <small
                                                        class="text-danger font-italic">*{{ $message }}</small> @enderror
                                                </div>
                                            </div>
                                            <div class="col-xl-6 mt-4">
                                                <p class="primary_input_label">{{ __('whatsapp.disable_for_admin_panel') }}</p>
                                                <div class="d-flex radio-btn-flex">
                                                    <div class="me-3">
                                                        <input type="radio" name="disable_for_admin_panel"
                                                               {{ app('whatsapp_support_settings')->disable_for_admin_panel == 1 ? 'checked' : '' }} id="relationv"
                                                               value="1" class="common-radio relationButton" checked>
                                                        <label
                                                            for="relationv">{{ __('whatsapp.yes') }}</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="disable_for_admin_panel"
                                                               {{ app('whatsapp_support_settings')->disable_for_admin_panel == 0 ? 'checked' : '' }} id="relation3v"
                                                               value="0" class="common-radio relationButton">
                                                        <label
                                                            for="relation3v">{{ __('whatsapp.no') }}</label>
                                                    </div>
                                                    @error('disable_for_admin_panel') <small
                                                        class="text-danger font-italic">*{{ $message }}</small> @enderror
                                                </div>
                                            </div>

                                            <div class="col-xl-6 mt-4">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{ __('whatsapp.homepage_url') }}</label>
                                                    <input class="primary_input_field" name="homepage_url" type="text"
                                                           value="{{ app('whatsapp_support_settings')->homepage_url ?? '' }}">
                                                </div>
                                            </div>

                                            <div class="col-xl-6 mt-4">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="">{{ __('whatsapp.primary_number') }}
                                                        (<small
                                                            class="text-danger">{{ __('whatsapp.with_country_code') }}</small>)</label>
                                                    <input class="primary_input_field" name="primary_number" type="text"
                                                           value="{{ app('whatsapp_support_settings')->primary_number ?? '' }}">
                                                </div>
                                            </div>
                                            <div class="col-xl-6 mt-4">
                                                <x-upload-file
                                                    name="bubble_pic"
                                                    media_id="{{app('whatsapp_support_settings')->bubble_logo_media?->media_id}}"
                                                    label="  {{ __('whatsapp.whatsapp bubble logo') }}"/>
                                            </div>
                                            <div class="col-xl-6 mt-4">
                                                <x-upload-file
                                                    name="whatsapp_logo"
                                                    media_id="{{app('whatsapp_support_settings')->whatsapp_logo_media?->media_id}}"
                                                    label="  {{ __('whatsapp.whatsapp logo') }}"/>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 d-flex justify-content-center align-content-center">

                                            <button class="primary-btn fix-gr-bg  " type="submit"><i
                                                    class="ti-check"></i>{{ __('whatsapp.update') }}
                                            </button>
                                        </div>
                                    </form>

                                </div>
                            </div>

                            <div class="col-lg-12 mt-4">
                                <div class="white_box_30px">
                                    <div class="main-title mb-25">
                                        <h3 class="mb-0">{{ __('whatsapp.layout_settings') }}</h3>
                                    </div>

                                    <form action="{{ route('whatsapp-support.settings.update') }}" method="post">
                                        @csrf
                                        <div class="col-xl-12">
                                            <p class="primary_input_label mb-3">{{ __('whatsapp.choose_layout') }}</p>
                                            <div class="d-flex radio-btn-flex">
                                                <div class="me-3">
                                                    <input type="radio" name="layout"
                                                           {{ app('whatsapp_support_settings')->layout == 1 ? 'checked' : '' }} id="relationFather113"
                                                           value="1" class="common-radio relationButton">
                                                    <label for="relationFather113"><img style="border-radius: 10px"
                                                                                        src="{{ asset('public/whatsapp-support/preview-1.png') }}"
                                                                                        alt=""></label>
                                                </div>
                                                <div class="me-3">
                                                    <input type="radio" name="layout"
                                                           {{ app('whatsapp_support_settings')->layout == 2 ? 'checked' : '' }} id="relationMother1114"
                                                           value="2" class="common-radio relationButton">
                                                    <label for="relationMother1114"><img style="border-radius: 10px"
                                                                                         src="{{ asset('public/whatsapp-support/preview-2.png') }}"
                                                                                         alt=""></label>
                                                </div>
                                                <div class="me-3">
                                                    <input type="radio" name="layout"
                                                           {{ app('whatsapp_support_settings')->layout == 3 ? 'checked' : '' }} id="relationMother1115"
                                                           value="3" class="common-radio relationButton">
                                                    <label for="relationMother1115"><img style="border-radius: 10px"
                                                                                         src="{{ asset('public/whatsapp-support/preview-3.png') }}"
                                                                                         alt=""></label>
                                                </div>
                                                @error('layout') <small
                                                    class="text-danger font-italic">*{{ $message }}</small> @enderror
                                            </div>
                                        </div>
                                        <div class="col-lg-12 d-flex justify-content-center align-content-center">

                                            <button class="primary-btn fix-gr-bg  mt-3" type="submit"><i
                                                    class="ti-check"></i>{{ __('whatsapp.update') }}
                                            </button>
                                        </div>
                                    </form>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
