<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreateTaxSettingsTable extends Migration
{

    public function up()
    {
        Schema::create('tax_settings', function (Blueprint $table) {
            $table->id();
            $table->tinyInteger('status')->default(1);
            $table->integer('percentage')->default(0);
            $table->integer('lms_id')->default(1);
            $table->timestamps();
        });
        DB::table('tax_settings')->insert([
            'status' => 1,
            'percentage' => 0,
        ]);

        GenerateGeneralSetting(SaasDomain());
    }


    public function down()
    {
        Schema::dropIfExists('tax_settings');
    }
}
