<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\RolePermission\Entities\Permission;

class SurveyRolePermission extends Migration
{
    public function up()
    {
        $routes = [
            ['name' => 'Change Status', 'route' => 'survey.change_status', 'type' => 3, 'parent_route' => 'survey.survey_list', 'module' => 'Survey'],
            ['name' => 'Set Questions', 'route' => 'survey.question_assign', 'type' => 3, 'parent_route' => 'survey.survey_list', 'module' => 'Survey'],
            ['name' => 'User Based Report', 'route' => 'survey.user_based_report', 'type' => 3, 'parent_route' => 'survey.survey_list', 'module' => 'Survey'],
            ['name' => 'Question Based Report', 'route' => 'survey.question_based_report', 'type' => 3, 'parent_route' => 'survey.survey_list', 'module' => 'Survey'],
            ['name' => 'Graph Report', 'route' => 'survey.question_based_graph', 'type' => 3, 'parent_route' => 'survey.survey_list', 'module' => 'Survey'],


            ['name' => 'Survey', 'route' => 'survey', 'type' => 1, 'parent_route' => null, 'module' => 'Survey'],
            ['name' => 'Survey Group', 'route' => 'survey.group.index', 'type' => 2, 'parent_route' => 'survey', 'module' => 'Survey'],
            ['name' => 'Add', 'route' => 'survey.group.store', 'type' => 3, 'parent_route' => 'survey.group.index', 'module' => 'Survey'],
            ['name' => 'Edit', 'route' => 'survey.group.update', 'type' => 3, 'parent_route' => 'survey.group.index', 'module' => 'Survey'],
            ['name' => 'Delete', 'route' => 'survey.group.delete', 'type' => 3, 'parent_route' => 'survey.group.index', 'module' => 'Survey'],

            ['name' => 'Survey Bank', 'route' => 'survey.survey-bank-list', 'type' => 2, 'parent_route' => 'survey', 'module' => 'Survey'],
            ['name' => 'Add Question', 'route' => 'survey.survey-bank', 'type' => 3, 'parent_route' => 'survey.survey-bank-list', 'module' => 'Survey'],
            ['name' => 'Add', 'route' => 'survey.survey-bank.store', 'type' => 3, 'parent_route' => 'survey.survey-bank-list', 'module' => 'Survey'],
            ['name' => 'Edit', 'route' => 'survey.survey-bank-update', 'type' => 3, 'parent_route' => 'survey.survey-bank-list', 'module' => 'Survey'],
            ['name' => 'Delete', 'route' => 'survey.survey-bank-delete', 'type' => 3, 'parent_route' => 'survey.survey-bank-list', 'module' => 'Survey'],
            ['name' => 'Bulk Import', 'route' => 'survey.survey-bank-bulk', 'type' => 3, 'parent_route' => 'survey.survey-bank-list', 'module' => 'Survey'],

            ['name' => 'Survey List', 'route' => 'survey.survey_list', 'type' => 2, 'parent_route' => 'survey', 'module' => 'Survey'],
            ['name' => 'Add', 'route' => 'survey.survey_store', 'type' => 3, 'parent_route' => 'survey.survey_list', 'module' => 'Survey'],
            ['name' => 'Edit', 'route' => 'survey.survey_update', 'type' => 3, 'parent_route' => 'survey.survey_list', 'module' => 'Survey'],
            ['name' => 'Delete', 'route' => 'survey.survey_delete', 'type' => 3, 'parent_route' => 'survey.survey_list', 'module' => 'Survey'],
            ['name' => 'Participants', 'route' => 'survey.survey_participants', 'type' => 3, 'parent_route' => 'survey.survey_list', 'module' => 'Survey'],


            ['name' => 'Survey Setting', 'route' => 'survey.setting', 'type' => 2, 'parent_route' => 'survey', 'module' => 'Survey'],
        ];


        permissionUpdateOrCreate($routes);


    }

    public function down()
    {
        //
    }
}
