<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInfixSubmitAssignmentsTable extends Migration
{

    public function up()
    {
        Schema::create('infix_submit_assignments', function (Blueprint $table) {
            $table->id();
            $table->integer('assignment_id');
            $table->integer('assign_id')->nullable();
            $table->integer('student_id');
            $table->double('marks')->nullable();
            $table->longText('answer')->nullable();
            $table->string('file')->nullable();
            $table->integer('is_marked')->nullable();
            $table->integer('assignment_from')->default(1)->nullable();
            $table->integer('marked_by')->nullable();
            $table->integer('lms_id')->default(1);

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('infix_submit_assignments');
    }
}
