<?php

namespace Modules\Appointment\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Contracts\Support\Renderable;
use Modules\Appointment\Repositories\Interfaces\SettingsRepositoryInterface;

class SettingsController extends Controller
{
    protected $settingRepository;

    public function __construct(
        SettingsRepositoryInterface $settingRepository
    )
    {
        $this->settingRepository = $settingRepository;
    }

    public function index()
    {
        $data = $this->settingRepository->index();
        return view('appointment::settings.settings', $data);
    }


    public function update(Request $request, $id)
    {
        $data = $this->settingRepository->update($id, $request->all());
        $msg = 'ok';
        return response()->json(['msg' => $msg]);
    }

    public function create()
    {
        return view('appointment::create');
    }


}
