<?php

namespace Modules\Appointment\Entities;

use App\Traits\Tenantable;
use Illuminate\Database\Eloquent\Model;
use Modules\CourseSetting\Entities\Category;

class RequestPost extends Model
{
    use Tenantable;

    protected $fillable = ['teaching_category', 'headline', 'name', 'email', 'max_price', 'min_price', 'requirement', 'user_id'];

    public function userInfo()
    {
        return $this->belongsTo('App\User', 'user_id', 'id')->withDefault();
    }
    public function category()
    {
        return $this->belongsTo('Modules\CourseSetting\Entities\Category', 'teaching_category', 'id')->withDefault();
    }
}
