<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Modules\SystemSetting\Entities\EmailTemplate;

class AddRowEmailTemplate extends Migration
{
    public function up()
    {
        // student Enroll
        EmailTemplate::insert([
            'act' => 'Appointment_Enroll_Payment',
            'name' => 'Appointment Enroll Payment ',
            'subj' => 'Appointment Enroll Successfully',
            'email_body' => 'You have enroll  {{timeSlot}} and {{topic}} . Your enrolled have been successfully . Price :  {{price}} . You are already paid {{price}}  via {{gateway}} on {{time}} . Your  instructor {{instructor}}.  {{footer}} ',
            'shortcodes' => '{"time":"Enroll Time","topic":"Topic","timeSlot":"Time Slot","price":"Hour Rate","instructor":"Instructor Name","gateway":"Payment Method",}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        // admin
        EmailTemplate::insert([
            'act' => 'Appointment_Enroll_Admin',
            'name' => 'New Appointment Enroll Admin',
            'subj' => 'New Appointment Enroll',
            'email_body' => '{{student_name}}, enroll  {{timeSlot}} and {{topic}} . Student enrolled have been successfully . Price :  {{price}} . Student already paid {{price}}  via {{gateway}} on {{time}} And   instructor {{instructor}}.  {{footer}} ',
            'shortcodes' => '{"time":"Enroll Time","topic":"Topic","timeSlot":"Time Slot","price":"Hour Rate","instructor":"Instructor Name","gateway":"Payment Method", "student_name":"Student Name"}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        // instructor
        EmailTemplate::insert([
            'act' => 'Appointment_Enroll_Instructor',
            'name' => 'New Appointment Enroll Instructor',
            'subj' => 'New Appointment Enroll',
            'email_body' => '{{student_name}}, enroll  {{timeSlot}} and {{topic}} . Student already paid {{price}}  via {{gateway}} on {{time}} .  {{footer}} ',
            'shortcodes' => '{"time":"Enroll Time","topic":"Topic","timeSlot":"Time Slot","price":"Hour Rate","gateway":"Payment Method", "student_name":"Student Name"}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Approve appointment
        EmailTemplate::insert([
            'act' => 'Appointment_Approve',
            'name' => 'Approved Appointment',
            'subj' => 'Approved Appointment',
            'email_body' => 'Congratulations!! {{ student_name }} Your Appointment has been Approved at {{time}},Your Appointment : {{timeSlot}}.{{footer}}',
            'shortcodes' => '{"student_name":"Student Name","timeSlot":"Time Slot","time":"Approve Time"}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        // reject appointment
        EmailTemplate::insert([
            'act' => 'Appointment_Reject',
            'name' => 'Appointment Reject',
            'subj' => 'Appointment Reject',
            'email_body' => 'Hello, {{ student_name }} ,Your Appointment Date was {{timeSlot}}.Sorry!! your appointment rejected at {{time}}. {{footer}} ',
            'shortcodes' => '{"student_name":"Student Name","timeSlot":"Time Slot","time":"Reject Time"}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        //book trail lesson-student
        EmailTemplate::insert([
            'act' => 'Book_Trail_Lesson',
            'name' => 'Book Trail Lesson',
            'subj' => 'Book Trail Lesson',
            'email_body' => 'You have enroll this {{instructor}}. Your enrolled have been successfully . Please Wait For Approval.  {{footer}} ',
            'shortcodes' => '{"instructor":"Instructor Name"}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        //book trail lesson-Admin
        EmailTemplate::insert([
            'act' => 'Book_Trail_Lesson_Admin',
            'name' => 'New Trail Lesson Request',
            'subj' => 'New Trail Lesson Request',
            'email_body' => '{{instructor}} Received Trail Lesson Request From {{student}} .  {{footer}} ',
            'shortcodes' => '{"instructor":"Instructor Name","student":"Student Name"}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        //book trail lesson-instructor
        EmailTemplate::insert([
            'act' => 'Book_Trail_Lesson_Instructor',
            'name' => 'New Trail Lesson Request',
            'subj' => 'New Trail Lesson Request',
            'email_body' => 'You have Receive Trail Lesson Request From Student.  {{footer}} ',
            'shortcodes' => '{"student":"Student Name"}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);


        //Book Trail Lesson Rejected->student
        EmailTemplate::insert([
            'act' => 'Book_Trail_Lesson_Rejected',
            'name' => 'Book Trail Lesson Rejected',
            'subj' => 'Book Trail Lesson Rejected',
            'email_body' => 'You have enrolled {{instructor}} for Appointment . Admin rejected your enrollment at {{time}}. {{footer}} ',
            'shortcodes' => '{"instructor":"Instructor Name","time":"Reject Time",}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        //Book Trail Lesson Approve->student
        EmailTemplate::insert([
            'act' => 'Book_Trail_Lesson_Approve',
            'name' => 'Book Trail Lesson Approve',
            'subj' => 'Book Trail Lesson Approve',
            'email_body' => 'You have enrolled {{instructor}} for Appointment .
            Your Appointment {{date}} and {{timeSlot}} . {{footer}}',
            'shortcodes' => '{"instructor":"Instructor Name","time":"Approve Time","date":"Schedule Date", "timeSlot":" Time Slot"}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        // student receive

        // schedule change->student
        EmailTemplate::insert([
            'act' => 'Schedule_Change',
            'name' => 'Schedule Change',
            'subj' => 'Schedule Change',
            'email_body' => 'Hi, {{student_name}} .Your Appointment {{date}}  and  {{timeSlot}}. {{footer}} ',
            'shortcodes' => '{"student_name":"Student Name", "date":"Schedule Date","timeSlot":"Time Slot"}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        // share Link->student
        EmailTemplate::insert([
            'act' => 'Share_Link',
            'name' => 'Share Link',
            'subj' => 'Share Link',
            'email_body' => 'Hi {{student_name}}, Your Appointment Time  {{timeSlot}} and {{date}}
            {{link}}
            . {{footer}} ',
            'shortcodes' => '{"student_name":"Student Name", "link":"Link", "timeSlot":"timeSlot", "date":"Date" }',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
         //receive instructor himself
        EmailTemplate::insert([
            'act' => 'Become_Instructor',
            'name' => 'Become Instructor',
            'subj' => 'Become Instructor',
            'email_body' => 'Hi ,{{name}}!! Thanks For Apply Become A Instructor.Please Wait For Approval. {{footer}} ',
            'shortcodes' => '{"name":"Name"}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        // become instructor
        EmailTemplate::insert([
            'act' => 'Become_Instructor_Request',
            'name' => 'Become Instructor Request',
            'subj' => 'Become Instructor Request',
            'email_body' => 'You Have got A request.Please Check it',
            'shortcodes' => '{"name":"Name"}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        //receive admin,instructor

        // reject Become Instructor
        EmailTemplate::insert([
            'act' => 'Reject_Instructor',
            'name' => 'Reject Instructor',
            'subj' => 'Reject Instructor',
            'email_body' => 'Sorry ,{{name}}!! Your Application Reject. {{footer}}',
            'shortcodes' => '{"name":"Name"}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // move slot -Admin

        EmailTemplate::insert([
            'act' => 'Schedule_Move_Admin',
            'name' => 'Schedule Move',
            'subj' => 'Schedule Move',
            'email_body' => 'Hi {{instructor}},Admin Change Your Appointment Schedule , Your Date {{date}} and {{timeSlot}}. {{footer}}',
            'shortcodes' => '{"instructor":"Instructor Name","date":"Schedule Date","timeSlot":"Time"}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // move slot -student

        EmailTemplate::insert([
            'act' => 'Schedule_Move_Student',
            'name' => 'Schedule Move',
            'subj' => 'Schedule Move',
            'email_body' => 'You have enrolled {{instructor}} for Appointment .
            Your Appointment change {{date}} and {{timeSlot}} . {{footer}}',
            'shortcodes' => '{"instructor":"Instructor Name","date":"Schedule Date","timeSlot":"Time Slot"}',
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('role_email_templates')->insert([
            'role_id' => 3,
            'template_act' => 'Appointment_Enroll_Payment',
            'status' => 1,
        ]);
        DB::table('role_email_templates')->insert([
            'role_id' => 1,
            'template_act' => 'Appointment_Enroll_Admin',
            'status' => 1,
        ]);
        DB::table('role_email_templates')->insert([
            'role_id' => 2,
            'template_act' => 'Appointment_Enroll_Instructor',
            'status' => 1,
        ]);

        DB::table('role_email_templates')->insert([
            'role_id' => 3,
            'template_act' => 'Book_Trail_Lesson',
            'status' => 1,
        ]);

        DB::table('role_email_templates')->insert([
            'role_id' => 1,
            'template_act' => 'Book_Trail_Lesson_Admin',
            'status' => 1,
        ]);

        DB::table('role_email_templates')->insert([
            'role_id' => 2,
            'template_act' => 'Book_Trail_Lesson_Instructor',
            'status' => 1,
        ]);

        DB::table('role_email_templates')->insert([
            'role_id' => 3,
            'template_act' => 'Book_Trail_Lesson_Rejected',
            'status' => 1,
        ]);
        DB::table('role_email_templates')->insert([
            'role_id' => 3,
            'template_act' => 'Book_Trail_Lesson_Approve',
            'status' => 1,
        ]);

        DB::table('role_email_templates')->insert([
            'role_id' => 3,
            'template_act' => 'Share_Link',
            'status' => 1,
        ]);
        DB::table('role_email_templates')->insert([
            'role_id' => 3,
            'template_act' => 'Schedule_Change',
            'status' => 1,
        ]);
        DB::table('role_email_templates')->insert([
            'role_id' => 2,
            'template_act' => 'Become_Instructor_Request',
            'status' => 1,
        ]);
        DB::table('role_email_templates')->insert([
            'role_id' => 1,
            'template_act' => 'Become_Instructor_Request',
            'status' => 1,
        ]);
        DB::table('role_email_templates')->insert([
            'role_id' => 1,
            'template_act' => 'Reject_Instructor',
            'status' => 1,
        ]);
        DB::table('role_email_templates')->insert([
            'role_id' => 3,
            'template_act' => 'Appointment_Approve',
            'status' => 1,
        ]);
        DB::table('role_email_templates')->insert([
            'role_id' => 3,
            'template_act' => 'Appointment_Reject',
            'status' => 1,
        ]);
        DB::table('role_email_templates')->insert([
            'role_id' => 2,
            'template_act' => 'Schedule_Move_Admin',
            'status' => 1,
        ]);
        DB::table('role_email_templates')->insert([
            'role_id' => 3,
            'template_act' => 'Schedule_Move_Student',
            'status' => 1,
        ]);

    }


    public function down()
    {
        //
    }
}
