<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSchedulesTable extends Migration
{
    public function up()
    {
        Schema::create('schedules', function (Blueprint $table) {
            $table->id();
            $table->date('schedule_date')->nullable();
            $table->string('day')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->integer('slot_id')->nullable();
            $table->integer('user_id')->nullable()->comment('instructor');
            $table->integer('total_booked')->nullable();
            $table->float('revenue')->default(0.00);
            $table->float('discount_price')->nullable();
            $table->integer('category_id')->nullable();
            $table->integer('sub_category_id')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->integer('special_commission')->nullable();
            $table->tinyInteger('status')->nullable()->default(1);
            $table->integer('lms_id')->default(1);

            $table->timestamps();
        });
    }


    public function down()
    {
        Schema::dropIfExists('schedules');
    }
}
