<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInstructorEducationTable extends Migration
{
    public function up()
    {
        Schema::create('instructor_education', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('instructor_id')->nullable();
            $table->foreign('instructor_id')->on('users')->references('id')->cascadeOnDelete();
            $table->string('duration')->nullable();
            $table->string('degree')->nullable();
            $table->string('institute')->nullable();
            $table->tinyInteger('is_verified')->nullable()->default(0);
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->tinyInteger('status')->nullable()->default(1);
            $table->integer('lms_id')->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('instructor_education');
    }
}
