@extends('backend.master')

@section('mainContent')

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor mb-20 student-details">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">

                    @includeIf('affiliate::commissions.partials.nav')

                    <!-- Tab panes -->
                    <div class="tab-content">
                        @includeIf('affiliate::commissions.partials.flat')
                        @includeIf('affiliate::commissions.partials.course')

                        @if (isModuleActive('BundleSubscription'))
                            @includeIf('affiliate::commissions.partials.bundle')
                        @endif
                        @if (isModuleActive('Subscription'))
                            @includeIf('affiliate::commissions.partials.subscription')
                        @endif


                    </div>


                </div>
            </div>
        </div>
    </section>
    @include('backend.partials.delete_modal')
    @include('setting::page_components.script')
@endsection
@push('scripts')
    <script>
        (function ($) {
            "use strict";


            $(document).on('change', '.commission_type', function (event) {
                let type = $(this).val();
                if (type === 'Flat') {
                    $('.commissionTypePercentage').addClass('d-none');
                    $('.commissionTypeAmount').removeClass('d-none');
                } else {
                    $('.commissionTypePercentage').removeClass('d-none');
                    $('.commissionTypeAmount').addClass('d-none');
                }
            });

            $(document).on('change', '.course_commission_type', function (event) {
                let type = $(this).val();
                if (type === 'Flat') {
                    $('.commissionCourseTypePercentage').addClass('d-none');
                    $('.commissionCourseTypeAmount').removeClass('d-none');
                } else {
                    $('.commissionCourseTypePercentage').removeClass('d-none');
                    $('.commissionCourseTypeAmount').addClass('d-none');
                }
            });


            $(document).on('change', '.bundle_commission_type', function (event) {
                let type = $(this).val();
                if (type === 'Flat') {
                    $('.commissionBundleTypePercentage').addClass('d-none');
                    $('.commissionBundleTypeAmount').removeClass('d-none');
                } else {
                    $('.commissionBundleTypePercentage').removeClass('d-none');
                    $('.commissionBundleTypeAmount').addClass('d-none');
                }
            });

        })(jQuery);

    </script>
@endpush
