<?php

namespace Modules\Affiliate\Http\Requests;

use App\Traits\ValidationMessage;
use Illuminate\Foundation\Http\FormRequest;

class BalanceTransferRequest extends FormRequest
{

    use ValidationMessage;


    public function rules()
    {
        $this->merge([
            'user_id' => auth()->id(),
            'payment_type' =>3,
        ]);

        return [
            'user_id'=>'required',
            'transfer_amount'=>'required',
            'payment_type'=>'required',
        ];

    }

    public function authorize()
    {
        return true;
    }
}
