<?php $__env->startSection('mainContent'); ?>

    <?php echo generateBreadcrumb(); ?>


    <section class="admin-visitor-area up_st_admin_visitor mb-20 student-details">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">
                    <div class="row ">

                        <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-20" role="tablist">
                            <li class="nav-item m-1">
                                <a class="nav-link <?php if(!Session::has('course') && !Session::has('instructor')): ?>active <?php endif; ?> "
                                   href="#Flat"
                                   role="tab" data-bs-toggle="tab"><?php echo e(__('setting.Flat Commission')); ?></a>
                            </li>
                            <li class="nav-item m-1">
                                <a class="nav-link <?php if(Session::has('instructor')): ?>active <?php endif; ?>"
                                   href="#Instructor"
                                   role="tab" data-bs-toggle="tab">
                                    <?php if(isModuleActive('Organization')): ?>
                                        <?php echo e(__('setting.Instructor or Organization Commission')); ?>

                                    <?php else: ?>
                                        <?php echo e(__('setting.Instructor Commission')); ?>

                                    <?php endif; ?>
                                </a>

                            </li>
                            <li class="nav-item m-1">
                                <a class="nav-link <?php if(Session::has('course')): ?> active <?php endif; ?>"
                                   href="#Course"
                                   role="tab" data-bs-toggle="tab"><?php echo e(__('setting.Course Commission')); ?></a>
                            </li>
                        </ul>
                    </div>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div
                            class="tab-pane fade   <?php if(!Session::has('course') && !Session::has('instructor')): ?>show active <?php endif; ?>"
                            id="Flat" role="tabpanel"
                            aria-labelledby="General-tab">
                            <div class="white-box">

                                <div class="main-title mb-25">
                                    <h3 class="mb-0"><?php echo e(__('courses.Course Fee Settings')); ?></h3>
                                </div>
                                <form
                                    action="<?php if(permissionCheck('setting.setCourseFee_update')): ?><?php echo e(route('saveFlat')); ?> <?php endif; ?>"
                                    method="post">

                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for=""><?php echo e(__('setting.Admin Revenue percentage of course fee')); ?></label>
                                                <input class="primary_input_field" max="100"
                                                       value="<?php echo e(@(int)$commission); ?>"
                                                       name="commission" placeholder="Admin Commission(%)"
                                                       oninput="calCommission()"
                                                       id="admin_comm" type="text">
                                            </div>
                                        </div>

                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for="">
                                                    <?php if(isModuleActive('Organization')): ?>
                                                        <?php echo e(__('setting.Instructor or Organization Revenue percentage of course fee')); ?>

                                                    <?php else: ?>
                                                        <?php echo e(__('setting.Instructor Revenue percentage of course fee')); ?>

                                                    <?php endif; ?>

                                                </label>

                                                <input class="primary_input_field"
                                                       value="<?php echo e(@(int)$instructor_commission); ?>"
                                                       readonly
                                                       name="instructor_comm" id="instructor_comm"
                                                       placeholder="Instructor Commission(%)"
                                                       type="text">
                                            </div>
                                        </div>


                                        <?php
                                            $tooltip = "";
                                            if(permissionCheck('setting.setCourseFee_update')){
                                                $tooltip = "";
                                            }else{
                                                $tooltip = "You have no permission to add";
                                            }
                                        ?>

                                        <div class="col-12 mb-10 pt_15">
                                            <div class="submit_btn text-center">
                                                <button class="primary-btn fix-gr-bg" data-bs-toggle="tooltip"
                                                        title="<?php echo e($tooltip); ?>" type="submit"><i
                                                        class="ti-check"></i> <?php echo e(__('common.Save')); ?></button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>


                        </div>

                        <div class="tab-pane fade <?php if(Session::has('instructor')): ?>show active <?php endif; ?> " id="Instructor"
                             role="tabpanel"
                             aria-labelledby="General-tab">
                            <div class="white-box">
                                <div class="main-title mb-25">
                                    <h3 class="mb-0"><?php echo e(__('courses.Specific Instructor Commission Setup')); ?></h3>
                                </div>

                                <form
                                    action="<?php if(permissionCheck('setting.instructorCommission_update')): ?><?php echo e(route('instructor_commission')); ?> <?php endif; ?>"
                                    method="post">

                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for=""><?php echo e(__('common.Select')); ?> <?php echo e(__('courses.Instructor')); ?></label>
                                                <select name="user_id" class="primary_select mb-25" required>
                                                    <option
                                                        value=""><?php echo e(__('common.Select')); ?> <?php echo e(__('courses.Instructor')); ?></option>
                                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                        <option
                                                            value="<?php echo e(@$user->id); ?>"
                                                            <?php if(Session::has('user_id')): ?>
                                                                <?php if(Session::get('user_id')==$user->id): ?>
                                                                    selected
                                                            <?php endif; ?>
                                                            <?php endif; ?>
                                                        >
                                                            <img class="tab_thumb" src="<?php echo e(asset(@$user->image)); ?>"
                                                                 alt=""> <?php echo e(@$user->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for=""><?php echo e(__('setting.Instructor Revenue percentage of course fee')); ?></label>
                                                <input class="primary_input_field"
                                                       value="<?php if(Session::has('amount')): ?><?php echo e(Session::get('amount')); ?><?php endif; ?>"
                                                       name="special_commission" id="instructor_comm"
                                                       placeholder="<?php echo e(__('setting.Instructor Commission')); ?>(%)"
                                                       type="number" min="0" required>

                                            </div>
                                        </div>


                                        <?php
                                            $tooltip = "";
                                            if(permissionCheck('setting.instructorCommission_update')){
                                                $tooltip = "";
                                            }else{
                                                $tooltip = "You have no permission to Update";
                                            }
                                        ?>

                                        <div class="col-12 mb-10 pt_15">
                                            <div class="submit_btn text-center">
                                                <button class="primary-btn fix-gr-bg" data-bs-toggle="tooltip"
                                                        title="<?php echo e($tooltip); ?>" type="submit"><i
                                                        class="ti-check"></i> <?php echo e(__('common.Update')); ?> <?php echo e(__('setting.Settings')); ?>

                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <div class="col-lg-12 mt-20">
                                <div class="white-box">

                                    <div class="box_header">
                                        <div class="main-title d-flex flex-wrap mb-0">
                                            <h3 class="mb-0"><?php echo e(__('setting.Specific Instructor List')); ?></h3>
                                        </div>
                                    </div>
                                    <div class="QA_section QA_section_heading_custom check_box_table">
                                        <div class="QA_table ">
                                            <!-- table-responsive -->
                                            <div class="">
                                                <table class="table Crm_table_active3">
                                                    <thead>
                                                    <tr>
                                                        <th scope="col"> <?php echo e(__('common.SL')); ?> </th>
                                                        <th scope="col"> <?php echo e(__('common.Name')); ?> </th>
                                                        
                                                        <th scope="col"> <?php echo e(__('courses.Instructor Commission')); ?> </th>
                                                        <th scope="col"> <?php echo e(__('courses.Admin Commission')); ?> </th>
                                                        <th scope="col"> <?php echo e(__('common.Email')); ?> </th>
                                                        <th scope="col"> <?php echo e(__('common.Action')); ?> </th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php $__currentLoopData = $instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $admin_commission=100-$instructor->special_commission;
                                                        ?>
                                                        <tr>
                                                            <th><?php echo e($key+1); ?></th>

                                                            <td class="nowrap"><?php echo e(@$instructor->name); ?></td>
                                                            
                                                            <td class="nowrap"><?php echo e(@$instructor->special_commission); ?></td>
                                                            <td class="nowrap"><?php echo e(@$admin_commission); ?></td>
                                                            <td class="nowrap"><?php echo e(@$instructor->email); ?></td>
                                                            <td class="nowrap">


                                                                <div class="dropdown CRM_dropdown">
                                                                    <button class="btn btn-secondary dropdown-toggle"
                                                                            type="button"
                                                                            id="dropdownMenu2<?php echo e(@$instructor->id); ?>"
                                                                            data-bs-toggle="dropdown"
                                                                            aria-haspopup="true"
                                                                            aria-expanded="false">
                                                                        <?php echo e(__('common.Action')); ?>

                                                                    </button>
                                                                    <div class="dropdown-menu dropdown-menu-right"
                                                                         aria-labelledby="dropdownMenu2<?php echo e(@$instructor->id); ?>">
                                                                        <?php if(permissionCheck('setting.instructorCommission_edit')): ?>
                                                                            <a href="#" data-bs-toggle="modal"
                                                                               data-bs-target="#editInstractor<?php echo e(@$instructor->id); ?>"
                                                                               class="dropdown-item"
                                                                               type="button"><?php echo e(__('common.Edit')); ?></a>
                                                                        <?php endif; ?>

                                                                    </div>
                                                                </div>
                                                            </td>

                                                        </tr>


                                                        <div class="modal fade admin-query"
                                                             id="editInstractor<?php echo e(@$instructor->id); ?>">
                                                            <div class="modal-dialog modal_800px modal-dialog-centered">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h4 class="modal-title"><?php echo e(__('common.Update')); ?> <?php echo e(__('courses.Commission')); ?> </h4>
                                                                        <button type="button" class="close "
                                                                                data-bs-dismiss="modal">
                                                                            <i class="ti-close "></i>
                                                                        </button>
                                                                    </div>

                                                                    <div class="modal-body">
                                                                        <form
                                                                            action="<?php echo e(route('instructor_commission')); ?>"
                                                                            method="post">
                                                                            <?php echo csrf_field(); ?>
                                                                            <input type="hidden" name="user_id"
                                                                                   value="<?php echo e(@$instructor->id); ?>">
                                                                            <div class="row">
                                                                                <div class="col-xl-12">
                                                                                    <div class="primary_input mb-25">
                                                                                        <label
                                                                                            class="primary_input_label"
                                                                                            for=""><?php echo e(__('courses.Instructor Commission Percentage')); ?></label>
                                                                                        <div class="tagInput_field">
                                                                                            <input
                                                                                                class="primary_input_field"
                                                                                                name="special_commission"
                                                                                                type="text"
                                                                                                value="<?php echo e(@(int)$instructor->special_commission); ?>">
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                                <div
                                                                                    class="col-lg-12 text-center pt_15">
                                                                                    <div
                                                                                        class="d-flex justify-content-center">
                                                                                        <button
                                                                                            class="primary-btn semi_large2  fix-gr-bg"
                                                                                            type="submit"><i
                                                                                                class="ti-check"></i><?php echo e(__('common.Update')); ?> <?php echo e(__('setting.Settings')); ?>

                                                                                        </button>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </form>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>


                        <div class="tab-pane fade <?php if(Session::has('course')): ?>show active <?php endif; ?> " id="Course"
                             role="tabpanel"
                             aria-labelledby="General-tab">
                            <div class="white-box">
                                <div class="main-title mb-25">
                                    <h3 class="mb-0"><?php echo e(__('setting.Specific Course Commission Setup')); ?> </h3>
                                </div>

                                <form
                                    action="<?php if(permissionCheck('setting.courseCommission_update')): ?><?php echo e(route('courseCommission')); ?> <?php endif; ?>"
                                    method="post">

                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for=""><?php echo e(__('courses.Select Course')); ?></label>
                                                <select name="course" class="primary_select mb-25" required>
                                                    <option value=""><?php echo e(__('courses.Select Course')); ?></option>
                                                    <?php $__currentLoopData = $allcourses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                        <option value="<?php echo e(@$course->id); ?>"
                                                                <?php if(Session::has('course_id')): ?>
                                                                    <?php if(Session::get('course_id')==$course->id): ?>
                                                                        selected
                                                            <?php endif; ?>
                                                            <?php endif; ?>
                                                        >  <?php echo e(@$course->title); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for="">
                                                    <?php if(isModuleActive('Organization')): ?>
                                                        <?php echo e(__('setting.Instructor or Organization Revenue percentage of course fee')); ?>

                                                    <?php else: ?>
                                                        <?php echo e(__('setting.Instructor Revenue percentage of course fee')); ?>

                                                    <?php endif; ?>
                                                </label>

                                                <input class="primary_input_field"
                                                       value="<?php if(Session::has('amount')): ?><?php echo e(Session::get('amount')); ?><?php endif; ?>"
                                                       name="course_commission" id="instructor_comm"
                                                       placeholder="<?php echo e(isModuleActive('Organization')?trans('setting.Instructor or Organization Commission'):trans('setting.Instructor Commission')); ?> (%)"
                                                       type="number" min="0" required>
                                            </div>
                                        </div>


                                        <?php
                                            $tooltip = "";
                                            if(permissionCheck('setting.courseCommission_update')){
                                                $tooltip = "";
                                            }else{
                                                $tooltip = "You have no permission to Update";
                                            }
                                        ?>

                                        <div class="col-12 mb-10 pt_15">
                                            <div class="submit_btn text-center">
                                                <button class="primary-btn fix-gr-bg" type="submit"><i
                                                        class="ti-check"></i> <?php echo e(__('common.Update')); ?> <?php echo e(__('setting.Setting')); ?>

                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="col-lg-12 mt-20 p-0">
                                <div class="box_header">
                                    <div class="main-title d-flex flex-wrap mb-0">
                                        <h3 class="mb-0"><?php echo e(__('setting.Specific Course List')); ?></h3>
                                    </div>
                                </div>

                                <div class="QA_section QA_section_heading_custom check_box_table">
                                    <div class="QA_table ">
                                        <!-- table-responsive -->
                                        <div class="">
                                            <table id="lms_table" class="table Crm_table_active3">
                                                <thead>
                                                <tr>

                                                    <th scope="col"> <?php echo e(__('common.SL')); ?> </th>
                                                    <th scope="col"> <?php echo e(__('common.Image')); ?> </th>
                                                    <th scope="col"> <?php echo e(__('courses.Course Title')); ?> </th>
                                                    <th scope="col"> <?php echo e(__('courses.Created')); ?> </th>
                                                    <th scope="col"> <?php echo e(__('courses.Instructor Revenue')); ?> </th>
                                                    <th scope="col"> <?php echo e(__('courses.Admin Revenue')); ?> </th>
                                                    <th scope="col"> <?php echo e(__('courses.Enrolls')); ?> </th>
                                                    <th scope="col"> <?php echo e(__('common.Action')); ?> </th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php
                                                        $admin_commission=100-$course->special_commission;
                                                    ?>
                                                    <tr>
                                                        <th><?php echo e($key+1); ?></th>

                                                        <td class="nowrap">
                                                            <div class="profile_info">
                                                                <img
                                                                    src="<?php echo e(getProfileImage($course->user->image,$course->user->name)); ?>">
                                                            </div>
                                                        </td>
                                                        <td class="nowrap"><?php echo e(@$course->title); ?></td>
                                                        <td class="nowrap"><?php echo e(@$course->user->name); ?></td>
                                                        <td class="nowrap"><?php echo e(@$course->special_commission); ?></td>
                                                        <td class="nowrap"><?php echo e(@$admin_commission); ?></td>
                                                        <td class="nowrap"><?php echo e(@$course->enrollCount); ?></td>
                                                        <td class="nowrap">


                                                            <div class="dropdown CRM_dropdown">
                                                                <button class="btn btn-secondary dropdown-toggle"
                                                                        type="button"
                                                                        id="dropdownMenu3<?php echo e(@$course->id); ?>"
                                                                        data-bs-toggle="dropdown"
                                                                        aria-haspopup="true"
                                                                        aria-expanded="false">
                                                                    <?php echo e(__('common.Action')); ?>

                                                                </button>
                                                                <div class="dropdown-menu dropdown-menu-right"
                                                                     aria-labelledby="dropdownMenu3<?php echo e(@$course->id); ?>">
                                                                    <?php if(permissionCheck('setting.courseCommission_edit')): ?>
                                                                        <a href="#" data-bs-toggle="modal"
                                                                           data-bs-target="#editCourse<?php echo e(@$course->id); ?>"
                                                                           class="dropdown-item"
                                                                           type="button"><?php echo e(__('common.Edit')); ?></a>
                                                                    <?php endif; ?>

                                                                    <?php if(permissionCheck('setting.courseCommission.delete')): ?>
                                                                        <a href="<?php echo e(route('setting.courseCommission.delete',@$course->id)); ?>"
                                                                           class="dropdown-item delete_course_commission"
                                                                           type="button"><?php echo e(__('common.Delete')); ?></a>
                                                                    <?php endif; ?>

                                                                </div>
                                                            </div>
                                                        </td>

                                                    </tr>


                                                    <div class="modal fade admin-query"
                                                         id="editCourse<?php echo e(@$course->id); ?>">
                                                        <div class="modal-dialog modal_800px modal-dialog-centered">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h4 class="modal-title"><?php echo e(@$course->title); ?></h4>
                                                                    <button type="button" class="close "
                                                                            data-bs-dismiss="modal">
                                                                        <i class="ti-close "></i>
                                                                    </button>
                                                                </div>

                                                                <div class="modal-body">
                                                                    <form action="<?php echo e(route('courseCommission')); ?>"
                                                                          method="post">
                                                                        <?php echo csrf_field(); ?>
                                                                        <input type="hidden" name="course"
                                                                               value="<?php echo e(@$course->id); ?>">
                                                                        <div class="row">
                                                                            <div class="col-xl-12">
                                                                                <div class="primary_input mb-25">
                                                                                    <label class="primary_input_label"
                                                                                           for=""><?php echo e(__('courses.Instructor Commission Percentage')); ?></label>
                                                                                    <div class="tagInput_field">
                                                                                        <input
                                                                                            class="primary_input_field"
                                                                                            name="course_commission"
                                                                                            type="text"
                                                                                            value="<?php echo e(@(int)$course->special_commission); ?>">
                                                                                    </div>
                                                                                </div>
                                                                            </div>

                                                                            <div class="col-lg-12 text-center pt_15">
                                                                                <div
                                                                                    class="d-flex justify-content-center">
                                                                                    <button
                                                                                        class="primary-btn semi_large2  fix-gr-bg"
                                                                                        type="submit"><i
                                                                                            class="ti-check"></i><?php echo e(__('common.Update')); ?> <?php echo e(__('setting.Settings')); ?>

                                                                                    </button>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </form>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>


                </div>
            </div>
        </div>
    </section>
    <?php echo $__env->make('backend.partials.delete_modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('setting::page_components.script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        (function ($) {
            "use strict";

            $(document).ready(function () {

                $(document).on('click', '.delete_course_commission', function (event) {
                    event.preventDefault();
                    let link = $(this).attr('href');
                    confirm_modal(link);
                });
            });
        })(jQuery);

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/Payment/Providers/../Resources/views/commission.blade.php ENDPATH**/ ?>