@php use Modules\CourseSetting\Entities\CourseEnrolled;use Modules\Store\Entities\LabelConfig; @endphp
    <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{$order->package_code}} Label</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap"
          rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            font-size: 14px;
            margin: 0;
            padding: 0;
        }

        table {
            border-collapse: collapse;
        }

        h1, h2, h3, h4, h5, h6 {
            margin: 0;
            color: #101010;
        }

        .invoice_wrapper {
            max-width: 1200px;
            margin: auto;
            background: #fff;
            padding: 20px;
        }

        .table {
            width: 100%;
            margin-bottom: 1rem;
            color: #212529;
        }

        .border_none {
            border: 0px solid transparent;
            border-top: 0px solid transparent !important;
        }

        .invoice_part_iner {
            background-color: #fff;
        }

        .table_border thead {
            background-color: #F6F8FA;
        }

        .table td, .table th {
            padding: 5px 0;
            vertical-align: top;
            border-top: 0 solid transparent;
            color: #101010;
        }

        .table td, .table th {
            padding: 5px 0;
            vertical-align: top;
            border-top: 0 solid transparent;
            color: #101010;
        }

        .table_border tr {
            border-bottom: 1px solid #101010 !important;
        }

        th p span, td p span {
            color: #212E40;
        }

        .table th {
            color: #101010;
            border: 1px solid #101010 !important;
        }

        p {
            font-size: 14px;
            color: #101010;
        }

        h5 {
            font-size: 12px;
            font-weight: 500;
        }

        h6 {
            font-size: 10px;
            font-weight: 300;
        }

        .mt_40 {
            margin-top: 40px;
        }

        .table_style th, .table_style td {
            padding: 20px;
        }

        .invoice_info_table td {
            font-size: 10px;
            padding: 0px;
        }


        .virtical_middle {
            vertical-align: middle !important;
        }

        .logo_img {
            max-width: 120px;
        }

        .logo_img img {
            width: 100%;
        }

        .border_bottom {
            border-bottom: 1px solid #000;
        }

        .line_grid {
            display: grid;
            grid-template-columns: 110px auto;
            grid-gap: 10px;
        }

        .line_grid span {
            display: flex;
            justify-content: space-between;
        }

        .line_grid2 {
            display: grid;
            grid-template-columns:  auto 110px;
            grid-gap: 10px;
        }

        .line_grid2 span {
            display: flex;
            justify-content: space-between;
        }

        p {
            margin: 0;
        }

        .font_18 {
            font-size: 18px;
        }

        .mb-0 {
            margin-bottom: 0;
        }

        .mb_30 {
            margin-bottom: 30px !important;
        }

        .mb_15 {
            margin-bottom: 15px !important;
        }

        .border_table {
        }

        .border_table thead tr th {
            padding: 5px;
        }

        .border_table tbody tr td {
            border: 1px solid #101010 !important;
            text-align: center;
            padding: 5px;
        }

        td, th {
            color: #101010;
            font-weight: 500;
            padding: 5px;

        }

        table {
            width: 100%;
        }

        .text_right {
            text-align: right !important;
        }

        .text_left {
            text-align: left !important;
        }

        .text_center {
            text-align: center !important;
        }

        .border_table tbody tr td.text_right {
            text-align: right !important;
        }

        .border_table tbody tr td.text_left {
            text-align: left !important;
        }

        .border_table tbody tr td.text_center {
            text-align: center !important;
        }

        .email_break {
            word-break: break-word;
        }
    </style>
</head>
<body>
<div class="invoice_wrapper">
    <div class="invoice_print mb_15">
        <div class="container">
            <div class="invoice_part_iner">
                <table class="table">
                    <tbody>
                    <tr>
                        <td style="width: 50%;">
                            <!-- single table  -->
                            <table>
                                <tbody>
                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                <span>
                                                    <span>{{__('product.deliver_to')}}</span>
                                                </span>
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                <span>
                                                    <span>{{@$order->order->user->name}}</span>
                                                </span>
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                <span>
                                                    <span>{{__('product.addresses')}}</span>
                                                    <span>:</span>
                                                </span>
                                            {{@$order->order->user->address}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                <span>
                                                    <span>{{__('product.city')}}</span>
                                                    <span>:</span>
                                                </span>
                                            {{@$order->order->user->cityDetails->name}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                <span>
                                                    <span>{{__('product.state')}}</span>
                                                    <span>:</span>
                                                </span>
                                            {{@$order->order->user->stateDetails->name}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                <span>
                                                    <span>{{__('product.Country')}}</span>
                                                    <span>:</span>
                                                </span>
                                            {{@$order->order->user->userCountry->name}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                <span>
                                                    <span>{{__('product.zip')}}</span>
                                                    <span>:</span>
                                                </span>
                                            {{@$order->order->user->zip}}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                <span>
                                                    <span>{{__('product.email')}}</span>
                                                    <span>:</span>
                                                </span>
                                            {{ $order->order->user->email }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                <span>
                                                    <span>{{__('product.phone')}}</span>
                                                    <span>:</span>
                                                </span>
                                            {{@$order->order->user->phone}}
                                        </p>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            <!--/ single table  -->
                        </td>

                        <td style="width: 50%;">
                            <table>
                                <tbody>

                                <tr>
                                    <td>
                                        <p style="text-align: right;" class="">

                                            <span>
                                                    <span></span>
                                                    <span>{{__('product.shipped_by')}}</span>
                                                </span>
                                        </p>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <p style="text-align: right;" class="">

                                            <span>
                                                    <span></span>
                                                    <span>{{$order->pickupPoint->name}}</span>
                                                </span>
                                        </p>
                                    </td>
                                </tr>


                                <tr>
                                    <td>
                                        <p style="text-align: right;" class="line_grid2">

                                            {{__('product.addresses')}}
                                            <span>
                                                    <span>:</span>
                                                    <span>{{$order->pickupPoint->address}}</span>
                                                </span>
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p style="text-align: right;" class="line_grid2">

                                            {{__('product.city')}}
                                            <span>
                                                    <span>:</span>
                                                    <span>{{$order->pickupPoint->city->name}}</span>
                                                </span>
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p style="text-align: right;" class="line_grid2">

                                            {{__('product.state')}}
                                            <span>
                                                    <span>:</span>
                                                    <span>{{$order->pickupPoint->state->name}}</span>
                                                </span>
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p style="text-align: right;" class="line_grid2">

                                            {{__('product.Country')}}
                                            <span>
                                                    <span>:</span>
                                                    <span>{{$order->pickupPoint->country->name}}</span>
                                                </span>
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p style="text-align: right;" class="line_grid2">

                                            {{__('product.pin_code')}}
                                            <span>
                                                    <span>:</span>
                                                    <span>{{$order->pickupPoint->pin_code}}</span>
                                                </span>
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p style="text-align: right;" class="line_grid2">

                                            {{__('product.email')}}
                                            <span>
                                                    <span>:</span>
                                                    <span class="email_break">{{$order->pickupPoint->email}}</span>
                                                </span>
                                        </p>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <p style="text-align: right;" class="line_grid2">

                                            {{__('product.phone')}}
                                            <span>
                                                    <span>:</span>
                                                    <span>{{$order->pickupPoint->phone}}</span>
                                                </span>
                                        </p>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            <!--/ single table  -->
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!-- invoice print part end -->
    <hr>
    <table>
        <tbody>
        <tr>
            @if(sellerWiseShippingConfig($order->seller_id)['label_code'] == 'barcode' || sellerWiseShippingConfig($order->seller_id)['label_code'] == 'both')
                <td>
                    {{__('product.package')}} # : {{$order->package_code}} <br/> <br/>
                    {!! '<img src="data:image/png;base64,' . DNS1D::getBarcodePNG($order->package_code, 'C39+',3,33,array(1,1,1)) . '" alt="barcode" style="width: 250px;height: 25px;" />' !!}
                </td>
            @endif
            @if(sellerWiseShippingConfig($order->seller_id)['label_code'] == 'qrcode' || sellerWiseShippingConfig($order->seller_id)['label_code'] == 'both')
                <td class="text_right">
                    @if(sellerWiseShippingConfig($order->seller_id)['label_code'] == 'qrcode')
                        {{__('product.package')}} # : {{$order->package_code}} <br/> <br/>
                    @endif
                    @php
                        $code = DNS2D::getBarcodeSVG($order->package_code,'QRCODE',3,3);
                        $code =  str_replace('<?xml version="1.0" standalone="no"?>','',$code);//preg_replace('/<\!--.*?-->/', '', $code);
                    @endphp
                    {!! $code !!}
                </td>
            @endif
        </tr>
        </tbody>
    </table>
    <hr>

    <table class="table border_table mb_30">
        <thead>
        <tr>
            <th>{{__('product.items')}}</th>
            <th>{{__('product.quantity')}}</th>
            <th class="text_right">{{__('product.Price')}}</th>
            <th class="text_right">{{ __('student.Total') }}</th>
        </tr>
        </thead>
        <tbody>
        @php
            $p_total = 0;
            $p_qty = 0;
            $sub_total = 0;
            $others = 0;
            $total = 0;
            $qty = 0;
            $tax_amt = 0;
            $shipping_cost = 0;
            $all_product = \Modules\Store\Entities\OrderPackageDetail::with('course')->where('order_id', $order->order_id)->get();
        @endphp
        @foreach($all_product as $key => $item)
            @if($item->course->product->type  == 2)
                <tr>
                    <td class="">{{$item->course->title}}</td>
                    <td>{{$item->number_of_product}}</td>
                    @php

                        //                         if ($item->is_store == 1) {
                        //                            $price1 = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;
                        //                            $price = $price1 * $item->number_of_product;
                        //                        } else {
                        //                            $price = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;
                        //                            $price1 = $price;
                        //                        }
                                            $enroll =\Modules\CourseSetting\Entities\CourseEnrolled::where('tracking',$item->order->tracking)->where('course_id',$item->course_id)->first();

                        if ($enroll){
                            $price =$enroll->purchase_price * $enroll->qty;
                            $price1 = $enroll->purchase_price;
                        }

                                                $total = $total + $price;
                                                $qty = $qty+($item->number_of_product*$item->tax_amount);
                                                $shipping_cost = $shipping_cost + $item->shipping_cost;
                                                $tax_amt = $tax_amt + $item->tax_amount;

                    @endphp

                    <td class="text_right">
                        {{ getPriceFormat($price1) }}
                    </td>
                    <td class="text_right">
                        {{ getPriceFormat($price) }}
                    </td>
                </tr>
            @endif
        @endforeach

        @php
            $p_total = $p_total + $total;
            if (isModuleActive('Tax')) {
                $p_qty = $p_qty + $qty;
            }
        @endphp
        <tr>
            <td colspan="3" class="text_right">{{__('product.sub_total')}}</td>
            <td class="text_right">{{  getPriceFormat($p_total) }}</td>
        </tr>
        <tr>
            <td colspan="3" class="text_right">{{__('product.Tax')}}/ {{ __('product.Shipping Charge') }}</td>
            <td class="text_right">{{getPriceFormat($tax_amt+$shipping_cost)}}</td>
        </tr>
        <tr>
            <td colspan="3" class="text_right">{{__('product.total')}}</td>
            <td class="text_right">{{ getPriceFormat($p_total+$tax_amt+$shipping_cost) }}</td>
        </tr>
        </tbody>
    </table>
    <table>
        <tbody>
        <tr>
            <td>{{__('product.invoice_no')}}: {{$order->order->order_number}} | {{__('product.invoice_date')}}
                : {{ showDate($order->created_at) }}</td>
        </tr>
        @php
            $terms = LabelConfig::where('created_by',$order->seller_id)->get();
        @endphp
        @if(count($terms) > 0)
            <tr>
                <td>{{__('product.terms_and_conditions')}}</td>
            </tr>
            @foreach($terms as $key => $term)
                <tr>
                    <td>{{$key+1}}.{{$term->condition}}</td>
                </tr>
            @endforeach
        @endif
        </tbody>
    </table>
</div>
<script src="{{ asset('public/js/common.js') }}"></script>
<script type="text/javascript">
    (function ($) {
        "use strict";
        $(document).ready(function () {
            window.print();
        });
    })(jQuery);
</script>
</body>
</html>
