<?php

namespace Modules\Store\Repositories;

use App\Traits\UploadMedia;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Modules\Store\Entities\ProductAuthor;
use Modules\Store\interfaces\CrudInterface;

class ProductAuthorRepository implements CrudInterface
{
    use UploadMedia;

    public function create(Request $request)

    {


        $author = new ProductAuthor;

        if (isModuleActive('FrontendMultiLang')) {
            foreach ($request->name as $key => $name) {
                $author->setTranslation('title', $key, $name);
            }
            foreach ($request->description as $key => $description) {
                $author->setTranslation('description', $key, $description);
            }
        } else {
            $author->title = $request->name;
            $author->description = $request->description;

        }

        $author->status = 1;
        $author->publication_id = $request->publication_id;
        $author->user_id = Auth::id();
        $author->save();

        if ($request->image) {
            $author->image = $this->generateLink($request->image, $author->id, get_class($author), 'image');
        }
        $author->save();

        return $author;
    }

    public function delete($id)
    {

        $author = ProductAuthor::find($id)->delete();
        return $author;
    }

    public function update(Request $request)
    {


        $author = ProductAuthor::find($request->id);

        if (isModuleActive('FrontendMultiLang')) {

            foreach ($request->name as $key => $name) {
                $author->setTranslation('title', $key, $name);
            }
        } else {
            $author->title = $request->name;
        }

        if (isModuleActive('FrontendMultiLang')) {

            foreach ($request->description as $key => $description) {
                $author->setTranslation('description', $key, $description);
            }
        } else {
            $author->description = $request->description;
        }
        $author->publication_id = $request->publication_id;


        $author->image = null;
        $author->save();


        $this->removeLink($author->id, get_class($author));
        if ($request->image) {
            $author->image = $this->generateLink($request->image, $author->id, get_class($author), 'image');
        }
        $author->user_id = Auth::user()->id;
        $author->save();
        return $author;
    }
}
