<?php

namespace Modules\Store\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class RefundReasonRequest extends FormRequest
{
    public function rules()
    {
        return [
            'reason' => 'required|max:255|unique:refund_reasons,reason,' . $this->id,
        ];
    }

    public function messages()
    {
        return [
            'reason.required' => 'The reason field is required',
            'reason.*.unique' => 'The reason field is already be taken',
        ];
    }

    public function authorize()
    {
        return true;
    }
}
