<?php

namespace Modules\Store\Exports\DropDownSheets;

use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Events\AfterSheet;
use Modules\Store\Entities\ProductCategory;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class CategoryList implements FromQuery, WithTitle, WithMapping, WithEvents
{


    public function query()
    {
        return ProductCategory::query()
            ->where('status', 1)
            ->orderBy('position_order');
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return 'product_categories';
    }


    public function map($product_category): array
    {
        return [
            $product_category->title
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $event->sheet->setSheetState(Worksheet::SHEETSTATE_HIDDEN);
            },
        ];
    }
}
