<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Migrations\Migration;
use Modules\FrontendManage\Entities\FrontPage;
use Modules\FrontendManage\Entities\HeaderMenu;

class AddStoreToFrontendPage extends Migration
{
    public function up()
    {

        $page = FrontPage::where('slug', '/store')->first();
        if (!$page) {
            $page = new FrontPage();
        }
        $page->name = 'Store';
        $page->title = 'Store';
        $page->sub_title = 'Store';
        $page->details = $this->page();
        $page->slug = '/store';
        $page->status = 1;
        $page->is_static = 1;
        $page->save();


        $store = FrontPage::where('slug', '/store')->first();
        $header_menu = HeaderMenu::where('link', '/store')->first();
        if ($store && $header_menu == null) {
            $menu = new HeaderMenu();
            $menu->type = "Static Page";
            $menu->element_id = $store->id;
            $menu->title = $store->title;
            $menu->link = $store->slug;
            $menu->position = 8;
            $menu->save();

        }
    }

    public function down()
    {

    }

    public function page()
    {

        $html = '
            <div
    class="full-page"
    data-type="component-text"
    data-preview=""
    data-aoraeditor-title="All Store Page Section" data-aoraeditor-categories="Store Page">
    <div class="row">
        <div class="col-sm-12 ui-resizable" data-type="container-content">';
        $html .= view(theme('snippets.components._store_page_section'))->render();
        $html .= ' </div>
    </div>
</div>
        ';
        return $html;
    }
}
