<?php

namespace Modules\Appointment\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Appointment\Repositories\Interfaces\PageBuilderRepositoryInterface;

class PageBuilderController extends Controller
{
    public $pageBuilderRepository;

    public function __construct(
        PageBuilderRepositoryInterface $pageBuilderRepository
    )
    {
        $this->pageBuilderRepository = $pageBuilderRepository;
    }

    public function index()
    {
        $data = $this->pageBuilderRepository->index();
        return view('appointment::page.page', $data);
    }

    public function create()
    {
        return view('appointment::create');
    }


    public function show($id)
    {
        try {
            $data = $this->pageBuilderRepository->design($id);
            return view('appointment::page.show', $data);
        } catch (\Exception $e) {
            Toastr::error($e->getMessage(), trans('common.Error'));
            return response()->json(['error' => $e->getMessage()], 503);
        }
    }

    public function edit($id)
    {
        return view('appointment::edit');
    }

    public function design($id)
    {
        $data = $this->pageBuilderRepository->design($id);
        return view('appointment::page.design', $data);
    }

    public function update(Request $request, $id)
    {
        $this->pageBuilderRepository->update($id, $request->except('_token'));
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->back();
    }

    public function tutorFinder()
    {
        $data = $this->pageBuilderRepository->tutorFinder();
        return view('appointment::page.tutor-finder', $data);
    }



    public function snippet(Request $request)
    {
        try {
            $name = $request->name;
            return view('appointment::snippet.index', compact('name'));
        } catch (\Exception $e) {
            Toastr::error($e->getMessage(), trans('common.Error'));
            return response()->json(['error' => $e->getMessage()], 503);
        }
    }

    public function designUpdate(Request $request, $id)
    {
        try {
            $this->pageBuilderRepository->designUpdatePage($id, $request->except('_token'));
            return $this->reloadWithData();
        } catch (\Exception $e) {
            Toastr::error($e->getMessage(), trans('common.Error'));
            return response()->json(['error' => $e->getMessage()], 503);
        }
    }

    private function reloadWithData()
    {
        try {
            $data = $this->pageBuilderRepository->index();
            return response()->json([
                'TableData' => (string)view('appointment::page.page', $data),
            ], 200);
        } catch (\Exception $e) {
            Toastr::error($e->getMessage(), trans('common.Error'));
            return response()->json([
                'error' => $e->getMessage(),
            ], 503);
        }
    }
}
