<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnToCart extends Migration
{
    public function up()
    {
        Schema::table('carts', function (Blueprint $table) {
            if (!Schema::hasColumn('carts', 'type')) {
                $table->string('type')->nullable();
            }
            if (!Schema::hasColumn('carts', 'schedule_id')) {
                $table->integer('schedule_id')->nullable();
            }
            if (!Schema::hasColumn('carts', 'timezone')) {
                $table->integer('timezone')->nullable();
            }
            if (Schema::hasColumn('carts', 'course_id')) {
                $table->integer('course_id')->nullable()->change();
            }
        });
    }

    public function down()
    {
        Schema::table('carts', function (Blueprint $table) {
            $table->dropColumn('type');
            $table->dropColumn('timezone');
        });
    }
}
