<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInstructorSocialsTable extends Migration
{
    public function up()
    {
        Schema::create('instructor_socials', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('instructor_id')->nullable();
            $table->foreign('instructor_id')->on('users')->references('id')->cascadeOnDelete();
            $table->string('icon')->nullable();
            $table->string('url')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->integer('lms_id')->default(1);

            $table->timestamps();
        });
    }


    public function down()
    {
        Schema::dropIfExists('instructor_socials');
    }
}
