<?php

namespace Modules\Affiliate\Listeners;

use Browser;
use Modules\Affiliate\Entities\AffiliateLink;
use Modules\Affiliate\Entities\AffiliateLinkVisitTrackUser;
use Modules\Affiliate\Events\CheckAffiliateLink;
use Request;

class CheckAffiliateLinkListener
{

    public function handle(CheckAffiliateLink $event)
    {
        $data = [];
        $url = urldecode(url()->full());
        $data['affiliate_link_id'] = 0;
        $affiliate_link = AffiliateLink::where('affiliate_link', $url)->latest()->first();
        if ($affiliate_link) {
            $data['affiliate_link_id'] = $affiliate_link->id;
        } else {
            return true;
        }
        $data['ip'] = Request::ip();
        $data['agent'] = Browser::browserFamily() . '-' . Browser::platformName() . '-' . Browser::deviceModel();
        $flag = $this->checkVisitRecord($data);
        if (!empty($data['affiliate_link_id']) && $flag) {
            $visitRecord = $this->linkVisitTrack($data);
            if ($visitRecord) {
                $affiliate_link->update(['visits' => $affiliate_link->visits + 1]);
            }
        }

    }

    private function checkVisitRecord($data)
    {
        $row = AffiliateLinkVisitTrackUser::where('affiliate_link_id', $data['affiliate_link_id'])->where('ip', $data['ip'])->where('agent', $data['agent'])->latest()->first();
        if ($row) {
            return false;
        } else {
            return true;
        }
    }

    private function linkVisitTrack($data)
    {
        return AffiliateLinkVisitTrackUser::create([
            'affiliate_link_id' => (int)$data['affiliate_link_id'],
            'ip' => $data['ip'],
            'agent' => $data['agent'],
            'date' => date('Y-m-d'),
        ]);
    }
}
