<?php

namespace Modules\Affiliate\Entities;

use App\Traits\Tenantable;
use App\User;
use Illuminate\Database\Eloquent\Model;

class AffiliateLink extends Model
{
    use Tenantable;

    protected $guarded = [ 'id' ];

    public function owner()
    {
        return $this->belongsTo(User::class, 'owner_id');
    }

    public function registerUser()
    {
        return $this->hasMany(ReferralUser::class, 'affiliate_link_id');
    }

    public function payment()
    {
        return $this->hasMany(AffiliateReferralPayment::class, 'affiliate_link_id');
    }
}
