@extends('backend.master')
@php
    $table_name='survey_question_sets';
@endphp
@section('table')
    {{$table_name}}
@stop
@section('mainContent')
    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center  ">

                <div class="col-lg-12">

                    <div class="main-title">
                        <h3 class="mb_30 d-none" id="page_title">{{__('survey.Participants') }}</h3>

                    </div>

                    <div class="QA_section QA_section_heading_custom check_box_table white_box">
                        <div class="QA_table ">
                            <!-- table-responsive -->
                            <div class="">
                                <table id="lms_table" class="table Crm_table_active3">
                                    <thead>
                                    <tr>
                                        <th scope="col">{{__('common.SL')}}</th>
                                        <th scope="col">{{__('common.Name')}}</th>
                                        {{--                                        <th scope="col">Survey For</th>--}}
                                        <th scope="col">{{__('common.date')}}</th>
                                        <th scope="col">{{__('common.Action')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($survey_info->participants as $index => $survey)
                                        <tr>
                                            <td scope="col">{{ $index+1 }}</td>
                                            <td scope="col">
                                                @if ($survey_info->is_anonymous==1)
                                                    {{__('survey.Anonymous')}}
                                                @else
                                                    {{ @$survey->user->name }}
                                                @endif

                                            </td>
                                            {{--                                            <td scope="col">{{ @$survey->survey->available_for }}</td>--}}
                                            <td scope="col">{{ showDate(@$survey->updated_at) }}</td>
                                            <td scope="col">
                                                <a href="{{ route('survey.survey_participants_view', [$survey->survey_id,$survey->user_id]) }}"
                                                   class="primary-btn   w-fit fix-gr-bg text-white"
                                                   type="button">{{__('common.View')}}</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Add Modal Item_Details -->
            </div>
        </div>
    </section>
    <input type="hidden" name="status_route" class="status_route" value="{{ route('coupons.status_update') }}">

    @include('backend.partials.delete_modal')
@endsection

@push('scripts')
    <script type="application/javascript">

        (function ($) {
            "use strict";
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2,]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);

    </script>
@endpush
