<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Modules\Subscription\Entities\CourseSubscription;

class CreateCourseSubscriptionsTable extends Migration
{

    public function up()
    {
        Schema::create('course_subscriptions', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->integer('price')->nullable();
            $table->string('about')->nullable();
            $table->string('btn_txt')->nullable();
            $table->integer('days')->default(30);
            $table->integer('status')->default(1);
            $table->integer('order')->default(1);
            $table->integer('lms_id')->default(1);
            $table->timestamps();
        });

        DB::table('course_subscriptions')->insert([
            [
                'title' => 'Weekly',
                'price' => 15,
                'days' => 7,
                'btn_txt' => 'Subscribe Now',
                'about' => 'Get access to all courses and content for a week.',
                'order' => 1,
            ],
            [
                'title' => 'Monthly',
                'price' => 50,
                'days' => 30,
                'btn_txt' => 'Subscribe Now',
                'about' => 'Enjoy unlimited access to all courses and content for a month.',
                'order' => 2,
            ],
            [
                'title' => 'Yearly',
                'price' => 500,
                'days' => 365,
                'btn_txt' => 'Subscribe Now',
                'about' => 'Gain full access to all courses and content for a year at a discounted price.',
                'order' => 3,
            ],
        ]);

    }

    public function down()
    {
        Schema::dropIfExists('course_subscriptions');
    }
}
