<?php

namespace Modules\Store\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Store\Repositories\CarrierRepository;
use Modules\Store\Repositories\LabelConfigRepository;
use Modules\Store\Repositories\PickupLocationRepository;
use Modules\Store\Repositories\ShippingConfigurationRepository;

class ShippingController extends Controller
{
    protected $carrierRepo;
    protected $pickupLocationRepo;
    protected $labelConfigRepo;
    protected $shippingConfigRepo;

    public function __construct(CarrierRepository $carrierRepo, PickupLocationRepository $pickupLocationRepo, LabelConfigRepository $labelConfigRepo, ShippingConfigurationRepository $shippingConfigRepo)
    {
        $this->carrierRepo = $carrierRepo;
        $this->pickupLocationRepo = $pickupLocationRepo;
        $this->labelConfigRepo = $labelConfigRepo;
        $this->shippingConfigRepo = $shippingConfigRepo;
        $this->shippingConfigRepo = $shippingConfigRepo;
    }


    public function setting()
    {
        $carrierRepo = new CarrierRepository();
        $data['carriers'] = $carrierRepo->getActiveAll();
        $data['pickup_locations'] = $this->pickupLocationRepo->getActiveAll();
        $data['conditions'] = $this->labelConfigRepo->all();
        $data['row'] = $this->shippingConfigRepo->sellerConfig();

        return view('store::shipping.index', $data);
    }

    public function settingUpdate(Request $request)
    {
        try {
            DB::beginTransaction();
            $this->labelConfigRepo->update($request->only(['conditionIds', 'eCondition', 'conditions']));
            $this->shippingConfigRepo->configuration($request->except(['_token', 'conditionIds', 'eCondition', 'conditions']));
            DB::commit();
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return back();
        } catch (Exception $e) {dd($e);
            DB::rollBack();
            Toastr::error($e->getMessage(), trans('common.Error'));
            return response()->json(['error' => $e->getMessage()], 503);
        }
    }

    public function conditionDelete($id)
    {
        try {
            $this->labelConfigRepo->conditionDestroy($id);
            return response()->json(['status' => 200]);
        } catch (Exception $e) {
            Toastr::error($e->getMessage(), trans('common.Error'));
            return response()->json(['error' => $e->getMessage()], 503);
        }
    }

}
