<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStoreBankPaymentsTable extends Migration
{
    public function up()
    {
        Schema::create('store_bank_payments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('itemable_id')->nullable();
            $table->string('itemable_type', 255)->nullable();
            $table->string('bank_name')->nullable();
            $table->string('branch_name')->nullable();
            $table->string('account_number')->nullable();
            $table->string('account_holder')->nullable();
            $table->string('image_src')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('store_bank_payments');
    }
}
