<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\Store\Entities\RefundProcess;

class CreateRefundProcessesTable extends Migration
{
    public function up()
    {
        Schema::create('refund_processes', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('description')->nullable();
            $table->timestamps();
        });

        RefundProcess::create(['name' => 'Start', 'description' => 'The refund process has been started.']);
        RefundProcess::create(['name' => 'Processing', 'description' => 'The refund is processing.']);
        RefundProcess::create(['name' => 'Complete', 'description' => 'The refund is completed.']);
    }

    public function down()
    {
        Schema::dropIfExists('refund_processes');
    }
}
