@php
    $group =$noticeboard->group;
@endphp
<div class="modal-dialog modal_1000px modal-dialog-centered">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">{{__('common.Update')}}  @if($group==2)
                    {{__('courses.Course')}}
                @else
                    {{__('noticeboard.General')}}
                @endif
                {{__('noticeboard.Noticeboard')}} </h4>
            <button type="button" class="close " data-bs-dismiss="modal">
                <i class="ti-close "></i>
            </button>
        </div>

        <div class="modal-body">
            <form action="{{route($group==2?'noticeboard.course.update':'noticeboard.update')}}" method="POST"
                  enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="id" value="{{$noticeboard->id}}" id="noticeId">
                <input type="hidden" name="group" value="{{$group}}">

                <div class="row">
                    <div class="col-xl-12">
                        <div class="primary_input mb-25">
                            <label class="primary_input_label" for="">{{__('common.Title')}}
                                <strong
                                    class="text-danger">*</strong></label>
                            <input class="primary_input_field" name="title" placeholder="-"
                                   type="text" id=""
                                   value="{{ $noticeboard->title }}" {{$errors->first('title') ? 'autofocus' : ''}}>
                        </div>
                    </div>

                    <div class="col-xl-12">
                        <div class="primary_input mb-25">
                            <label class="primary_input_label" for="">{{__('common.Type')}}
                                <strong
                                    class="text-danger">*</strong></label>

                            <select {{ $errors->has('type') ? ' autofocus' : '' }}
                                    class="primary_select {{ $errors->has('type') ? ' is-invalid' : '' }}"
                                    id="editType" name="type">
                                <option data-display="{{__('common.Type')}} *"
                                        value="">  {{__('common.Type')}}
                                </option>
                                @foreach($types as $key=>$type)
                                    <option
                                        {{ $noticeboard->type==$key?'selected':''}} value="{{$key}}">{{$type}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    @if($group==2)
                        <div class="col-xl-12 mb-25 mt-25">
                            <label class="primary_input_label" for=""> {{__('common.Course')}}
                                <strong
                                    class="text-danger">*</strong></label>
                            <select name="course_id[]" id="editCourseId"
                                    class="multypol_check_select active mb-15 e1" multiple>
                                @foreach($courses as $key=>$course)
                                    <option
                                        {{ $noticeboard->assign->where('course_id',$key)->first()?'selected':''}}  value="{{$key}}">{{$course}}</option>
                                @endforeach
                            </select>
                        </div>
                    @else

                        <div class="col-xl-12 mb-25 mt-25">
                            <label class="primary_input_label" for="">{{__('common.Role')}}
                                <strong
                                    class="text-danger">*</strong></label>
                            <select name="role_id[]" id=""
                                    class="multypol_check_select active mb-15 e1" multiple>
                                @foreach($roles as $key=>$role)
                                    <option
                                        {{ $noticeboard->assign->where('role_id',$key)->first()?'selected':''}}  value="{{$key}}">{{$role}}</option>
                                @endforeach
                            </select>
                        </div>
                    @endif


                    <div class="col-xl-12">
                        <div class="primary_input mb-25">
                            <label class="primary_input_label" for="">{{__('noticeboard.Message')}}
                                <strong
                                    class="text-danger">*</strong></label>
                            <textarea name="message" class="lms_summernote"
                                      id="editMessage">{!! $noticeboard->message !!}</textarea>
                        </div>
                    </div>


                </div>

                <div class="col-lg-12 text-center pt_15">
                    <div class="d-flex justify-content-center">
                        <button class="primary-btn semi_large2  fix-gr-bg"
                                id="save_button_parent" type="submit"><i
                                class="ti-check"></i> {{__('common.Update')}} @if($group==2)
                                {{__('courses.Course')}}
                            @else
                                {{__('noticeboard.General')}}
                            @endif
                            {{__('noticeboard.Noticeboard')}}
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>


