<?php

use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\RolePermission\Entities\Permission;

class AddRemovePermissionForSurvey extends Migration
{
    public function up()
    {
        $delete_routes = [
            'survey.my_survey',
            'survey.survey_participate_store',
            'survey.set_attribute_delete',
            'survey.set_attribute_update',
            'survey.set_attribute_store',
            'survey.set_attribute',
            'survey.set_delete',
            'survey.set_update',
            'survey.set_store',
            'survey.set_list',
            'survey_report',
            'survey.user_based_report',
            'survey.question_based_report',
            'survey.question_based_graph',
            'survey.survey_set_question',
            'survey.question_assign'
        ];

        Permission::whereIn('route', $delete_routes)->delete();


        Cache::forget('PermissionList_' . SaasDomain());
        Cache::forget('RoleList_' . SaasDomain());
        Cache::forget('PolicyPermissionList_' . SaasDomain());
        Cache::forget('PolicyRoleList_' . SaasDomain());
    }

    public function down()
    {
        //
    }
}
