@extends('backend.master')


@php
    $table_name = 'product_carriers';
@endphp
@section('table')
    {{ $table_name }}
@endsection

@section('mainContent')

    @php
        $LanguageList = getLanguageList();
    @endphp

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-3">
                    <div class="box_header common_table_header">
                        <div class="main-title d-md-flex mb-0">
                            <h3 class="mb-0">
                                {{ @$data['title'] }}
                            </h3>
                            @if (isset($edit))
                                @if (permissionCheck('store.carrier.index'))
                                    <a href="{{ route('store.carrier.index') }}"
                                       class="primary-btn small fix-gr-bg ms-4"
                                       style="line-height: 25px;" title="{{ __('courses.Add New') }}">+</a>
                                @endif
                            @endif
                        </div>
                    </div>


                    <div class="white-box mb_30  student-details header-menu">


                        @if (isset($data['show']))
                            <form action="{{ route('store.carrier.update') }}" method="POST" id="category-form"
                                  name="category-form" enctype="multipart/form-data">
                                <input type="hidden" name="id" value="{{ $data['show']->id }}">
                                @else
                                    @if (permissionCheck('store.carrier.store'))
                                        <form action="{{ route('store.carrier.store') }}" method="POST"
                                              id="category-form"
                                              name="category-form" enctype="multipart/form-data">
                                            @endif
                                            @endif
                                            @csrf

                                            <div class="row">
                                                <div class="col-xl-12">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label"
                                                               for="nameInput">{{ __('common.Name') }}
                                                            <strong class="text-danger">*</strong></label>
                                                        <input name="name" id="nameInput"
                                                               class="primary_input_field name {{ @$errors->has('name') ? ' is-invalid' : '' }}"
                                                               placeholder="{{ __('common.Name') }}" type="text"
                                                               value="{{ isset($data['show']) ? $data['show']->name : old('name') }}">

                                                        @if ($errors->has('name'))
                                                            <span class="invalid-feedback d-block mb-10" role="alert">
                                            <strong>{{ @$errors->first('name') }}</strong>
                                        </span>
                                                        @endif

                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-xl-12">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label"
                                                               for="tracking_urlInput">{{ _trans('store.Traking Url') }}
                                                            <strong class="text-danger">*</strong></label>
                                                        <input name="tracking_url" id="tracking_urlInput"
                                                               class="primary_input_field tracking_url {{ @$errors->has('tracking_url') ? ' is-invalid' : '' }}"
                                                               placeholder="{{ _trans('store.Traking Url') }}"
                                                               type="text"
                                                               value="{{ isset($data['show']) ? $data['show']->tracking_url : old('tracking_url') }}">

                                                        @if ($errors->has('tracking_url'))
                                                            <span class="invalid-feedback d-block mb-10" role="alert">
                                            <strong>{{ @$errors->first('tracking_url') }}</strong>
                                        </span>
                                                        @endif

                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-xl-12">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label"
                                                               for="status">{{ __('courses.Status') }}</label>
                                                        <select class="primary_select mb-25" name="status" id="status">
                                                            <option
                                                                value="1" {{ isset($data['show']) ? ($data['show']->status == 1 ? 'selected' : '') : '' }}>
                                                                {{ __('common.Active') }}</option>
                                                            <option
                                                                value="0" {{ isset($data['show']) ? ($data['show']->status == 0 ? 'selected' : '') : '' }}>
                                                                {{ __('common.Inactive') }}</option>
                                                        </select>
                                                    </div>
                                                </div>


                                                <div class="col-lg-12 mt-10">
                                                    <div class="primary_input mb-15">
                                                        <label class="primary_input_label"
                                                               for="placeholderFileOneName">{{ _trans('common.Logo') }}
                                                        </label>
                                                        <div class="primary_file_uploader">
                                                            <input class="primary-input filePlaceholder" type="text"
                                                                   value="{{ isset($data['show']) ? $data['show']->image : '' }}"
                                                                   placeholder="{{ __('student.Browse Image file') }}"
                                                                   readonly=""
                                                                {{ $errors->has('logo') ? 'autofocus' : '' }}>
                                                            <button class="" type="button">
                                                                <label class="primary-btn small fix-gr-bg"
                                                                       for="document_file_1">{{ __('common.Browse') }}</label>
                                                                <input type="file" class="d-none fileUpload" name="logo"
                                                                       id="document_file_1">
                                                            </button>
                                                        </div>
                                                        <p class="image_size">{{ __('courses.Recommended size 300px x 300px') }}</p>
                                                        @if ($errors->has('logo'))
                                                            <span class="invalid-feedback d-block mb-10" role="alert">
                                            <strong>{{ @$errors->first('logo') }}</strong>
                                        </span>
                                                        @endif
                                                    </div>
                                                </div>


                                                @php
                                                    $tooltip = '';
                                                    if (permissionCheck('store.carrier.store')) {
                                                        $tooltip = '';
                                                    } else {
                                                        $tooltip = trans('courses.You have no permission to add');
                                                    }
                                                @endphp
                                                <div class="col-lg-12 text-center">
                                                    <div class="d-flex justify-content-center pt_20">
                                                        <button type="submit" class="primary-btn semi_large fix-gr-bg"
                                                                data-bs-toggle="tooltip"
                                                                title="{{ @$tooltip }}" id="save_button_parent">
                                                            <i class=" fa fa-check "></i>
                                                            @if (!isset($data['show']))
                                                                {{ __('common.Save') }}
                                                            @else
                                                                {{ __('common.Update') }}
                                                            @endif
                                                        </button>


                                                    </div>
                                                </div>
                                            </div>

                                        </form>
                    </div>


                </div>
                <div class="col-lg-9">
                    <div class="box_header common_table_header">
                        <div class="main-title d-md-flex mb-0">
                            <h3 class="mb-0">{{ _trans('store.Carriers List') }}</h3>
                        </div>
                    </div>
                    <div class="  QA_section QA_section_heading_custom check_box_table">
                        <div class="QA_table ">
                            <div class="">
                                <table id="lms_table" class="table table-data">
                                    <thead>
                                    <tr>
                                        <th scope="col">{{ __('common.SL') }}</th>
                                        <th scope="col">{{ __('common.Name') }}</th>
                                        <th scope="col">{{ __('common.Status') }}</th>
                                        <th scope="col">{{ __('common.Action') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach ($data['carriers'] as $key => $carrier)
                                        <tr>
                                            <td>{{ ++$key }}</td>
                                            <td> {{ @$carrier->name }}</td>


                                            <td class="nowrap">
                                                <x-backend.status :id="$carrier->id" :status="$carrier->status"
                                                                  :route="'store.author.status'">
                                                </x-backend.status>

                                            </td>

                                            <td>
                                                <div class="dropdown CRM_dropdown">
                                                    <button class="btn btn-secondary dropdown-toggle" type="button"
                                                            id="dropdownMenu1{{ @$carrier->id }}"
                                                            data-bs-toggle="dropdown"
                                                            aria-haspopup="true" aria-expanded="false">
                                                        {{ __('common.Select') }}
                                                    </button>
                                                    <div class="dropdown-menu dropdown-menu-right"
                                                         aria-labelledby="dropdownMenu1{{ @$carrier->id }}">
                                                        @if (permissionCheck('store.carrier.edit'))
                                                            <a class="dropdown-item edit_brand"
                                                               href="{{ route('store.carrier.edit', $carrier->id) }}">{{ __('common.Edit') }}</a>
                                                        @endif
                                                        @if (permissionCheck('store.carrier.destroy'))
                                                            <a onclick="confirm_modal('{{ route('store.carrier.destroy', $carrier->id) }}');"
                                                               class="dropdown-item edit_brand">{{ __('common.Delete') }}</a>
                                                        @endif
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    @include('store::partials.delete_modal')

@endsection


@push('scripts')
    <script src="{{ asset('/') }}/Modules/Store/Resources/assets/js/category.js"></script>
@endpush
