<form method="POST" enctype="multipart/form-data" id="editForm">
    @csrf
    @method('PUT')
    <div class="white_box p-15 box_shadow_white mb-20">
        <div class="box_header common_table_header">
            <div class="main-title d-md-flex">
                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{ _trans('store.Edit Pickup Location') }}</h3>
            </div>
        </div>

        <div class="row">
            <input type="hidden" value="{{$row->id}}" id="rowId">
            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="pickup_location"> {{_trans("store.pickup_location")}} <span
                            class="text-danger">*</span></label>
                    <input class="primary_input_field" name="pickup_location" id="pickup_location"
                           placeholder="{{_trans("store.pickup_location")}}" type="text"
                           value="{{$row->pickup_location}}">
                    <span class="text-danger" id="error_pickup_location"></span>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="name"> {{__("common.Name")}} <span
                            class="text-danger">*</span></label>
                    <input class="primary_input_field" name="name" id="name" placeholder="{{__("common.Name")}}"
                           type="text" value="{{$row->name}}">
                    <span class="text-danger" id="error_name"></span>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="email"> {{__("common.Email")}} <span
                            class="text-danger">*</span></label>
                    <input class="primary_input_field" name="email" id="email" placeholder="{{__("common.Email")}}"
                           type="text" value="{{$row->email}}">
                    <span class="text-danger" id="error_email"></span>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="phone"> {{__("common.Phone")}} <span
                            class="text-danger">*</span></label>
                    <input class="primary_input_field" name="phone" id="phone" placeholder="{{__("common.Phone")}}"
                           type="text" value="{{$row->phone}}">
                    <span class="text-danger" id="error_phone"></span>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="address"> {{__("common.Address")}} <span
                            class="text-danger">*</span></label>
                    <input class="primary_input_field" name="address" id="address"
                           placeholder="{{__("common.Address")}}" type="text" value="{{$row->address}}">
                    <span class="text-danger" id="error_address"></span>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="address_2"> {{_trans("store.Address_2")}} </label>
                    <input class="primary_input_field" name="address_2" id="address_2"
                           placeholder="{{_trans("store.Address_2")}}" type="text" value="{{$row->address_2}}">
                    <span class="text-danger" id="error_address_2"></span>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="pin_code"> {{_trans("store.pin_code")}}
                        /{{_trans('store.post_code')}} <span class="text-danger">*</span></label>
                    <input class="primary_input_field" name="pin_code" id="pin_code"
                           placeholder="{{_trans("store.pin_code")}}/{{_trans('store.post_code')}}" type="text"
                           value="{{$row->pin_code}}">
                    <span class="text-danger" id="error_pin_code"></span>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="business_country">{{_trans('store.Country Region')}} <span
                            class="text-danger">*</span></label>
                    <select name="country_id" id="business_country" class="primary_select mb-25">
                        <option value="" disabled selected>{{_trans('store.select_one')}}</option>
                        @foreach($countries as $country)
                            <option
                                {{$row->country_id == $country->id ?'selected':''}} value="{{$country->id}}">{{$country->name}}</option>
                        @endforeach
                    </select>
                    <span class="text-danger" id="error_country_id"></span>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="business_state">{{_trans('store.state')}} <span
                            class="text-danger">*</span></label>
                    <select name="state_id" id="business_state" class="primary_select mb-25">
                        <option value="" disabled selected>{{_trans('store.select_one')}}</option>
                        @foreach($states as $key => $state)
                            <option
                                {{$row->state_id== $state->id?'selected':''}} value="{{$state->id}}">{{$state->name}}</option>
                        @endforeach
                    </select>
                    <span class="text-danger" id="error_state_id"></span>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="business_city">{{_trans('store.city')}} </label>
                    <select name="city_id" id="business_city" class="primary_select mb-25">
                        <option value="" disabled selected>{{_trans('store.select_one')}}</option>
                        @foreach($cities as $key => $city)
                            <option
                                {{$row->city_id == $city->id?'selected':''}} value="{{$city->id}}">{{$city->name}}</option>
                        @endforeach
                    </select>
                    <span class="text-danger" id="error_city_id"></span>
                </div>
            </div>


            <div class="col-lg-12 text-center">
                <div class="d-flex justify-content-center pt_20">
                    <button type="submit" class="primary-btn semi_large update_btn fix-gr-bg"
                            id="save_button_parent">
                        <i class=" fa fa-check "></i>
                        {{__("common.Update")}}
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>

