@extends('backend.master')
@section('styles')
    <style>
        .anchore_color {
            color: #415094;
        }
    </style>
@endsection
@section('mainContent')
    {{generateBreadcrumb()}}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-lg-4">

                    <div class="create_div">

                        <form
                            action="{{ isset($edit)?route('store.refundprocess.update',$edit->id):route('store.refundprocess.store') }}"
                            method="POST">

                            @csrf
                            <div class=" white-box box_shadow_white mb-20">
                                <div class="box_header common_table_header">
                                    <div class="main-title d-md-flex">
                                        <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{ isset($edit) ? __('product.edit_refund_process') : __('product.add_refund_process') }}</h3>
                                    </div>
                                </div>


                                <div class="row">


                                    <div class="col-lg-12">
                                        <div class="primary_input mb-15">
                                            <label class="primary_input_label" for=""> {{__("product.process")}} <span
                                                    class="text-danger">*</span></label>
                                            <input class="primary_input_field" name="name" id="name"
                                                   placeholder="{{__("product.process")}}" type="text"
                                                   value="{{old('name',isset($edit)?$edit->name:'')}}">
                                            <span class="text-danger" id="name_create_error"></span>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="primary_input mb-15">
                                            <label class="primary_input_label" for=""> {{__("product.description")}}
                                                <span class="text-danger">*</span></label>
                                            <textarea class="primary_textarea height_112"
                                                      name="description">{{old('description',isset($edit)?$edit->description:'')}}</textarea>
                                            <span class="text-danger" id="description_create_error"></span>
                                        </div>
                                    </div>

                                    <div class="col-lg-12 text-center">
                                        <button type="submit" class="primary-btn semi_large fix-gr-bg"
                                                id="save_button_parent"><i
                                                class="ti-check"></i>{{ isset($edit) ?  __("common.Update") : __("common.Save")}}
                                        </button>
                                    </div>

                                </div>
                            </div>
                        </form>

                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="white-box">

                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title">{{ __('product.refund_process') }}</h3>
                            </div>
                        </div>
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table">
                                <div class="">
                                    <div id="refund_process_list">
                                        @include('store::refund.refund_process.process_list')
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <input type="hidden" name="app_base_url" id="app_base_url" value="{{ URL::to('/') }}">

    @include('backend.partials.delete_modal')
@endsection
@include('store::refund.refund_process.scripts')
